/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.dtw.classification;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.IOObjectCollection;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.dtw.classification.TimeSeriesPredictionModel;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.valueseries.Feature;
import com.rapidminer.operator.valueseries.ValueSeries;
import com.rapidminer.operator.valueseries.Vector;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import timeseriesclustering.GlobalConstraint;
import timeseriesclustering.NoConstraint;
import timeseriesclustering.Query;
import timeseriesclustering.SakoeChibaBand;

public class OneNearestNeighbor
extends Operator {
    private InputPort timeSeriesInput = (InputPort)this.getInputPorts().createPort("series-in");
    private OutputPort modelOutput = (OutputPort)this.getOutputPorts().createPort("model");

    public OneNearestNeighbor(OperatorDescription description) {
        super(description);
    }

    public void doWork() throws UserError {
        IOObjectCollection data;
        IOObjectCollection timeseries = data = (IOObjectCollection)this.timeSeriesInput.getData(IOObjectCollection.class);
        final HashMap<Double[], ValueSeries> adapter = new HashMap<Double[], ValueSeries>();
        final ArrayList<Double[]> database = new ArrayList<Double[]>();
        for (ValueSeries s : timeseries.getObjects()) {
            if (s.getSeriesData().getNumberOfDimensions() > 1) {
                throw new UserError((Operator)this, 1504, new Object[]{"Only Real Value Time Series supported"});
            }
            Vector[] v = s.getSeriesData().getVectors();
            Double[] conversion = new Double[v.length];
            for (int i = 0; i < v.length; ++i) {
                conversion[i] = v[i].getRealValue(0);
            }
            adapter.put(conversion, s);
            database.add(conversion);
        }
        final GlobalConstraint con = this.getParameterAsBoolean("Sakoe-Chiba-Band") ? new SakoeChibaBand(this.getParameterAsInt("Sakoe-Chiba-Band width")) : new NoConstraint();
        this.modelOutput.deliver((IOObject)new TimeSeriesPredictionModel(){
            private static final long serialVersionUID = 535014646939207898L;

            @Override
            protected void predict(ValueSeries ts, String feature) {
                Double[] conversion = new Double[ts.getSeriesData().getVectors().length];
                for (int i = 0; i < conversion.length; ++i) {
                    conversion[i] = ts.getSeriesData().getVector(i).getRealValue(0);
                }
                Query a = new Query(database, conversion, con);
                List features = ((ValueSeries)adapter.get(a.ts)).getFeatures();
                Feature addFeature = null;
                for (Feature f : features) {
                    if (!f.getName().equals("label")) continue;
                    addFeature = new Feature(feature, f.getValue());
                }
                if (addFeature != null) {
                    ts.addFeature(addFeature);
                }
            }
        });
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean("Sakoe-Chiba-Band", "Use a global constraint?", true));
        ParameterTypeInt width = new ParameterTypeInt("Sakoe-Chiba-Band width", "the width of the global constraint. 10% of time series length is a commonly used value", 0, Integer.MAX_VALUE, 16);
        width.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, "Sakoe-Chiba-Band", true, true));
        types.add(width);
        return types;
    }
}

