/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.IOObjectCollection;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.TimeSeriesOperator;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.CollectionMetaData;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.valueseries.ValueSeries;
import com.rapidminer.operator.valueseries.ValueSeriesData;
import com.rapidminer.operator.valueseries.ValueSeriesMetaData;
import com.rapidminer.operator.valueseries.Vector;
import java.util.Collection;
import timeseriesclustering.TimeSeriesClustering;

public class ZNormalize
extends TimeSeriesOperator {
    private InputPort timeSeriesInput = this.getInputPorts().createPort("series-in", IOObjectCollection.class);
    private OutputPort timeSeriesOutput = (OutputPort)this.getOutputPorts().createPort("series-out");

    public ZNormalize(OperatorDescription description) {
        super(description);
        this.getTransformer().addRule(new MDTransformationRule(){

            public void transformMD() {
                ZNormalize.this.timeSeriesOutput.deliverMD((MetaData)new CollectionMetaData((MetaData)new ValueSeriesMetaData()));
            }
        });
    }

    public void doWork() throws UserError {
        IOObjectCollection data;
        IOObjectCollection timeseries = data = (IOObjectCollection)this.timeSeriesInput.getData(IOObjectCollection.class);
        IOObjectCollection ret = new IOObjectCollection();
        for (ValueSeries v : timeseries.getObjects()) {
            Double[] a = this.convert(v);
            a = TimeSeriesClustering.normalize(a);
            Vector[] d = new Vector[a.length];
            for (int i = 0; i < a.length; ++i) {
                d[i] = new Vector(a[i].doubleValue());
            }
            ValueSeries valueSeries = new ValueSeries(new ValueSeriesData("normalized", null, d));
            valueSeries.addFeatures((Collection)v.getFeatures());
            ret.add((IOObject)valueSeries);
        }
        this.timeSeriesOutput.deliver((IOObject)ret);
    }
}

