/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.IOObjectCollection;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.valueseries.Feature;
import com.rapidminer.operator.valueseries.ValueSeries;
import com.rapidminer.operator.valueseries.Vector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class SaveTimeSeriesToExampleSet
extends Operator {
    private InputPort timeSeriesInput = this.getInputPorts().createPort("series", IOObjectCollection.class);
    private OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");

    public SaveTimeSeriesToExampleSet(OperatorDescription description) {
        super(description);
    }

    public void doWork() throws OperatorException {
        IOObjectCollection data;
        IOObjectCollection timeseries = data = (IOObjectCollection)this.timeSeriesInput.getData(IOObjectCollection.class);
        int length = 0;
        HashSet<String> features = new HashSet<String>();
        for (ValueSeries s : timeseries.getObjects()) {
            length = Math.max(length, s.getSeriesData().length());
            for (Feature f : s.getFeatures()) {
                features.add(f.getName());
            }
        }
        ArrayList<Object> attributes = new ArrayList<Object>();
        HashMap<String, Attribute> mapAttributes = new HashMap<String, Attribute>();
        for (int d = 0; d < length; ++d) {
            attributes.add(AttributeFactory.createAttribute((String)("t" + d), (int)4));
        }
        for (String a : features) {
            mapAttributes.put(a, AttributeFactory.createAttribute((String)a, (int)4));
            attributes.add(mapAttributes.get(a));
        }
        MemoryExampleTable table = new MemoryExampleTable(attributes);
        for (ValueSeries s : timeseries.getObjects()) {
            int i;
            Vector[] vectors = s.getSeriesData().getVectors();
            double[] dataPoints = new double[attributes.size()];
            for (i = 0; i < length; ++i) {
                dataPoints[i] = i < vectors.length ? vectors[i].getRealValue(0) : Double.NaN;
            }
            i = length;
            for (String fname : features) {
                for (Feature f : s.getFeatures()) {
                    if (!fname.equals(f.getName())) continue;
                    dataPoints[i] = f.getValue();
                }
                ++i;
            }
            table.addDataRow((DataRow)new DoubleArrayDataRow(dataPoints));
        }
        ExampleSet result = table.createExampleSet();
        for (String fname : features) {
            result.getAttributes().setSpecialAttribute((Attribute)mapAttributes.get(fname), fname);
        }
        this.exampleSetOutput.deliver((IOObject)result);
    }
}

