/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.IOObjectCollection;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.TimeSeriesOperator;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.valueseries.ValueSeries;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import java.util.ArrayList;
import java.util.List;
import timeseriesclustering.GlobalConstraint;
import timeseriesclustering.NoConstraint;
import timeseriesclustering.SakoeChibaBand;
import timeseriesclustering.averaging.AveragingTechnique;
import timeseriesclustering.averaging.EuclidianAveraging;
import timeseriesclustering.averaging.FastShapeBasedAveraging;
import timeseriesclustering.averaging.FixpointAveraging;
import timeseriesclustering.averaging.MedoidAveraging;
import timeseriesclustering.averaging.ProjectionAveraging;
import timeseriesclustering.averaging.ShapeBasedAveraging;

public class ComputeCentroid
extends TimeSeriesOperator {
    private InputPort timeSeriesInput = this.getInputPorts().createPort("series-in", IOObjectCollection.class);
    private OutputPort timeSeriesOutput = (OutputPort)this.getOutputPorts().createPort("series-out");

    public ComputeCentroid(OperatorDescription description) {
        super(description);
    }

    public void doWork() throws UserError {
        IOObjectCollection data;
        IOObjectCollection timeseries = data = (IOObjectCollection)this.timeSeriesInput.getData(IOObjectCollection.class);
        ArrayList<Double[]> adapterDatabase = new ArrayList<Double[]>();
        for (ValueSeries v : timeseries.getObjects()) {
            Double[] a = this.convert(v);
            adapterDatabase.add(a);
        }
        GlobalConstraint con = null;
        con = this.getParameterAsBoolean("Sakoe-Chiba-Band") ? new SakoeChibaBand(this.getParameterAsInt("Sakoe-Chiba-Band width")) : new NoConstraint();
        AveragingTechnique averager = this.getAveragingTechnique();
        this.timeSeriesOutput.deliver((IOObject)this.convert(averager.average(adapterDatabase, (Double[])adapterDatabase.get(0), con)));
    }

    private AveragingTechnique getAveragingTechnique() throws UndefinedParameterError {
        String name = this.getParameterAsString("averaging technique");
        if (name.equals("Euclidian")) {
            return new EuclidianAveraging();
        }
        if (name.equals("Projection")) {
            return new ProjectionAveraging();
        }
        if (name.equals("Fixpoint")) {
            return new FixpointAveraging();
        }
        if (name.equals("Shapebased")) {
            return new ShapeBasedAveraging();
        }
        if (name.equals("Fast Shapebased")) {
            return new FastShapeBasedAveraging();
        }
        if (name.equals("Medoids")) {
            return new MedoidAveraging();
        }
        return new EuclidianAveraging();
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeCategory("averaging technique", "the algorithm used to average a set of time series", new String[]{"Euclidian ", "Projection", "Fixpoint", "Shapebased", "Fast Shapebased", "Medoids"}, 1));
        types.add(new ParameterTypeBoolean("Sakoe-Chiba-Band", "Use a global constraint?", true));
        ParameterTypeInt width = new ParameterTypeInt("Sakoe-Chiba-Band width", "the width of the global constraint. 10% of time series length is a commonly used value", 0, Integer.MAX_VALUE, 16);
        width.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, "Sakoe-Chiba-Band", true, true));
        types.add(width);
        return types;
    }
}

