

%load data
load('data.mat');
% these are 4,000 amazon reviews (2,000 about books, 2,000 about
% electronics) together with sentiment labels
% the data was downloaded from
% and preprocessed to produce the word vectors as explained in the paper

%example for source and target domains
train = books';
test = electronics';
trainlabels = labelsbooks;
testlables = labelselectronics;
%dimension of the word vectors
p = size(train,1)
%dimension of the new feature representation
q = 100
% stiefel manifold
St = stiefelfactory(p, q);
%problem definition
problem.M = St;
problem.maxiter = 1000;
problem.verbosity = 0;
problem.tolgradnorm = 0.000000000001;

%sample random starting point on Stiefel manifold
M = problem.M.rand();

localdefaults.verbosity = 2;
% just for initialization
problem.cost = @(X) norm(X)^2;
problem.grad = @(X) (2*(X));
%perform optimization
[P cost info] = stochasticgradientdescent(problem,M,localdefaults,train',test',5);

%project into new low-dimensional latent feature representation
newtrain = P'*train;
newtest = P'*test;

%perform classification task (for instance SVM from libsvm)
model = svmtrain(trainlabels,newtrain','-t 2 -g 0.1 -c 10');
[l a co] = svmpredict(testlables,newtest',model,'-q');
a