function Grad = Grad_KernelMeanReg(S,T,W,s,w)
if nargin<4,
    s = 1;
end
   
if nargin<5,
    w = 1;
end

d1 = (S(1,:)-S(2,:))'*(S(1,:)-S(2,:));
d2 = (S(1,:)-T(2,:))'*(S(1,:)-T(2,:));
d3 = (S(2,:)-T(1,:))'*(S(2,:)-T(1,:));
d4 = (T(1,:)-T(2,:))'*(T(1,:)-T(2,:));

S2 = (W*S')';
T2 = (W*T')';

Grad = (-1/s)*1*((gausskernel(S2(1,:),S2(2,:),s)*d1-gausskernel(S2(1,:),T2(2,:),s)*d2 ...
     - 1*gausskernel(S2(2,:),T2(1,:),s)*d3 + gausskernel(T2(1,:),T2(2,:),s)*d4)*W')' ...
      - w*(W*[S(1,:)+S(2,:)+T(1,:)+T(2,:)]')*[S(1,:)+S(2,:)+T(1,:)+T(2,:)];    