/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware;

import com.ximpleware.IIntBuffer;
import com.ximpleware.arrayList;

public class FastIntBuffer
implements IIntBuffer {
    public static final int ASCENDING = 0;
    public static final int DESCENDING = 1;
    private arrayList bufferArrayList;
    private int capacity;
    private int pageSize;
    protected int size;
    private int exp;
    private int r;

    public FastIntBuffer() {
        this.size = 0;
        this.capacity = 0;
        this.pageSize = 1024;
        this.exp = 10;
        this.r = 1023;
        this.bufferArrayList = new arrayList();
    }

    public FastIntBuffer(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.size = 0;
        this.capacity = 0;
        this.pageSize = 1 << n;
        this.exp = n;
        this.r = this.pageSize - 1;
        this.bufferArrayList = new arrayList();
    }

    public final void append(int[] nArray) {
        int n;
        int[] nArray2;
        if (this.bufferArrayList.size == 0) {
            nArray2 = new int[this.pageSize];
            this.bufferArrayList.add(nArray2);
            n = 0;
            this.capacity = this.pageSize;
        } else {
            n = Math.min(this.size >> this.exp, this.bufferArrayList.size - 1);
            nArray2 = (int[])this.bufferArrayList.get(n);
        }
        if (this.size + nArray.length < this.capacity) {
            if (this.size + nArray.length < n + 1 << this.exp) {
                System.arraycopy(nArray, 0, nArray2, this.size & this.r, nArray.length);
            } else {
                int n2;
                int n3 = this.pageSize - (this.size & this.r);
                System.arraycopy(nArray, 0, nArray2, this.size & this.r, n3);
                int n4 = nArray.length - n3;
                int n5 = n4 >> this.exp;
                for (n2 = 1; n2 <= n5; ++n2) {
                    System.arraycopy(nArray, n3, (int[])this.bufferArrayList.get(n + n2), 0, this.pageSize);
                    n3 += this.pageSize;
                }
                System.arraycopy(nArray, n3, (int[])this.bufferArrayList.get(n + n2), 0, n4 & this.r);
            }
            this.size += nArray.length;
            return;
        }
        int n6 = (nArray.length + this.size >> this.exp) + ((nArray.length + this.size & this.r) > 0 ? 1 : 0) - (this.capacity >> this.exp);
        System.arraycopy(nArray, 0, nArray2, this.size & this.r, this.capacity - this.size);
        for (int i = 0; i < n6; ++i) {
            int[] nArray3 = new int[this.pageSize];
            if (i < n6 - 1) {
                System.arraycopy(nArray, this.pageSize * i + this.capacity - this.size, nArray3, 0, this.pageSize);
            } else {
                System.arraycopy(nArray, this.pageSize * i + this.capacity - this.size, nArray3, 0, nArray.length + this.size - this.capacity - this.pageSize * i);
            }
            this.bufferArrayList.add(nArray3);
        }
        this.size += nArray.length;
        this.capacity += n6 * this.pageSize;
    }

    public final void append(int n) {
        if (this.size < this.capacity) {
            ((int[])this.bufferArrayList.oa[this.size >> this.exp])[this.size & this.r] = n;
            ++this.size;
        } else {
            int[] nArray = new int[this.pageSize];
            ++this.size;
            this.capacity += this.pageSize;
            this.bufferArrayList.add(nArray);
            nArray[0] = n;
        }
    }

    public final int getCapacity() {
        return this.capacity;
    }

    public int[] getIntArray(int n, int n2) {
        if (this.size <= 0 || n < 0) {
            throw new IllegalArgumentException();
        }
        if (n + n2 > this.size) {
            throw new IndexOutOfBoundsException();
        }
        int[] nArray = new int[n2];
        int n3 = n >> this.exp;
        int n4 = n + n2 >> this.exp;
        if ((n + n2 & this.r) == 0) {
            --n4;
        }
        if (n3 == n4) {
            System.arraycopy((int[])this.bufferArrayList.get(n3), n & this.r, nArray, 0, n2);
        } else {
            int n5 = 0;
            for (int i = n3; i <= n4; ++i) {
                int[] nArray2 = (int[])this.bufferArrayList.get(i);
                if (i == n3) {
                    System.arraycopy(nArray2, n & this.r, nArray, 0, this.pageSize - (n & this.r));
                    n5 += this.pageSize - (n & this.r);
                    continue;
                }
                if (i == n4) {
                    System.arraycopy(nArray2, 0, nArray, n5, n2 - n5);
                    continue;
                }
                System.arraycopy(nArray2, 0, nArray, n5, this.pageSize);
                n5 += this.pageSize;
            }
        }
        return nArray;
    }

    public final int getPageSize() {
        return this.pageSize;
    }

    @Override
    public final int intAt(int n) {
        int n2 = n >> this.exp;
        int n3 = n & this.r;
        return ((int[])this.bufferArrayList.get(n2))[n3];
    }

    @Override
    public final void modifyEntry(int n, int n2) {
        ((int[])this.bufferArrayList.oa[n >> this.exp])[n & this.r] = n2;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public int[] toIntArray() {
        if (this.size > 0) {
            int n = this.size;
            int[] nArray = new int[this.size];
            int n2 = 0;
            int n3 = 0;
            while (n > 0) {
                System.arraycopy((int[])this.bufferArrayList.get(n3), 0, nArray, n2, n < this.pageSize ? n : this.pageSize);
                n -= this.pageSize;
                n2 += this.pageSize;
                ++n3;
            }
            return nArray;
        }
        return null;
    }

    public final void clear() {
        this.size = 0;
    }

    public final boolean resize(int n) {
        if (n <= this.capacity && n >= 0) {
            this.size = n;
            return true;
        }
        return false;
    }

    public void sort(int n) {
        switch (n) {
            case 0: {
                if (this.size <= 0) break;
                this.quickSort_ascending(0, this.size - 1);
                break;
            }
            case 1: {
                if (this.size <= 0) break;
                this.quickSort_descending(0, this.size - 1);
                break;
            }
            default: {
                throw new IllegalArgumentException("Sort type undefined");
            }
        }
    }

    void quickSort_ascending(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        int n5 = this.intAt((n + n2) / 2);
        while (true) {
            if (this.intAt(n3) < n5) {
                ++n3;
                continue;
            }
            while (this.intAt(n4) > n5) {
                --n4;
            }
            if (n3 <= n4) {
                int n6 = this.intAt(n3);
                this.modifyEntry(n3, this.intAt(n4));
                this.modifyEntry(n4, n6);
                ++n3;
                --n4;
            }
            if (n3 > n4) break;
        }
        if (n < n4) {
            this.quickSort_ascending(n, n4);
        }
        if (n3 < n2) {
            this.quickSort_ascending(n3, n2);
        }
    }

    void quickSort_descending(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        int n5 = this.intAt((n + n2) / 2);
        while (true) {
            if (this.intAt(n3) > n5) {
                ++n3;
                continue;
            }
            while (this.intAt(n4) < n5) {
                --n4;
            }
            if (n3 <= n4) {
                int n6 = this.intAt(n3);
                this.modifyEntry(n3, this.intAt(n4));
                this.modifyEntry(n4, n6);
                ++n3;
                --n4;
            }
            if (n3 > n4) break;
        }
        if (n < n4) {
            this.quickSort_descending(n, n4);
        }
        if (n3 < n2) {
            this.quickSort_descending(n3, n2);
        }
    }
}

