function [y1] = BQ05_TS30TS20Li(x1)
% BQ05_TS30TS20Li is neural network simulation function.
% It predicts TI BQ25505 efficiency according to the input voltage and
% current in addition to the storage voltage.
% 
% [y] = BQ05_TS30TS20Li(x) takes these arguments as:
%   x = [Vin, Vstr, Ii]'
%       Voltage values in V (Volt)
%       Current value in uA (micro Ampere)
% and returns:
%   y = efficiency (in percent)
% 
% This model has two hidden layers:
% first hidden layer including 30 neurons with tangent sigmoid transfer function 
% second hidden layer including 20 neurons with tangent sigmoid transfer function 
% and  a single neuron linear transfer function output layer.

% Coperight: Mojtaba Masoudinejad, 2018, Dortmund
% mojtaba.masoudinejad@tu-dortmund.de

% ===== NEURAL NETWORK CONSTANTS =====

% Input 1
x1_step1.xoffset = [0.328;1.5999;0.5];
x1_step1.gain = [0.447727781508843;0.769201184569824;1.99005965203807e-05];
x1_step1.ymin = -1;

% Layer 1
b1 = [92.898584192253395031;-41.03648291484712729;1.1105106965297570909;-6.4232150139224515328;13.604443430430151807;-10.24472140125007158;-20.805873620633263954;0.85022056977862114913;-35.297980385055268471;16.231458078843203907;3.217003098493796287;0.31392186763859375453;-0.96807484754583661424;-11.762556749150295587;0.016843490707898711028;14.538176099605404801;-1.5821430037953425618;-1.0827752278372688721;-12.028611217499378228;-0.66574209611310153356;17.52756553846695553;-0.55872886803831811608;47.493930985212585938;-15.334770670928378422;6.9027005071537601566;-16.184446721371251954;-87.540078544514699388;-7.2399782594742809749;-107.2258396309344306;22.555366252968539698];
IW1_1 = [-0.020097809716112965267 -0.5737703554969587616 93.685485454528119931;0.47926615398147215386 -0.65140714411405464812 -40.645651329629082227;0.11887071431903924179 -0.034378288065821945019 -0.46046779065058723868;-4.5516748943835994012 -0.40939011249180884411 -0.14639702442369245672;-4.930996747484639009 11.427985234236977874 6.6442689723659968948;13.138754883343388258 17.84454811757240833 -1.6460739232426500056;31.768050827316667295 -31.164892977154650566 -7.2512527484864692795;-8.0128780219387785166 5.4319232928580696296 0.012983561363590658683;27.43772699127811876 -16.440124213085226756 -39.583002198562070362;-10.82574867855815981 -30.932763016674432066 -8.4101452863403576288;-15.228694947566717488 8.9449535730909168763 -0.087401869247487953829;-9.2077084280072121203 5.0389900376400422743 1.2222866858697865045;9.0578682043216236508 -4.2648242259765236639 -1.1518057621251154288;1.1670770651585389288 18.596282271699852373 -27.879868747689517505;-0.40106646169942611335 -0.01292475519387123635 0.21968694398818619518;-1.2310345568233884705 26.146711829373259661 7.9792774549223128844;-19.012266564900169641 10.282988063539603374 -2.1485814942906542591;-7.6663992775099227828 27.026080359323508162 -25.319404209618394219;19.494264556761017104 -27.781430340564511994 -15.663727996639492446;1.7779473269764722865 -3.7803107629522902933 1.0956541667110026861;22.915196085484112132 -12.196218795205821195 12.708773133393359345;-2.7529538340882822034 0.88015192325846114407 2.3820893067452577618;1.4203132498941781758 0.19453198572184499104 46.88755033587137433;10.359589797985742976 29.048871356963079648 7.8269638819485809478;12.292753993031071857 -7.1131021402538472387 5.3535373574344893299;1.3545821223164984382 -17.534120515498223369 -5.1802698688553103779;-1.8431990546637049277 0.44856227550673838378 -86.261665353543648393;-1.2562270607973089476 2.0677576378091671039 -6.0350029599243857348;1.6673198792263159707 -0.35069072592035355207 -108.39693387820373971;27.261997732359436242 3.722004177931651725 -4.3814175522755141046];

% Layer 2
b2 = [-9.1357143562806228942;-14.236418202646564879;2.6852573466909221978;11.996116848977319336;5.8980840165755168414;0.15881768271911178569;-5.2867579167847305044;9.587779666294851566;1.3610115306804184687;-4.9997025606046987534;16.380245878443112417;17.980959643205718379;-5.4770865055270059329;-45.318878505667804291;15.814503571319979969;-5.7183528438235464719;-2.1059284598703889024;-4.1738353380294741513;7.8966652447301690643;14.472770472613747827];
LW2_1 = [8.0392189520264967229 -13.762533646040632007 7.5281953941330934654 -2.8977976434920362792 -0.64344685433274162456 0.054650398280990823696 0.0078613134781141767032 -1.152902067034871747 1.3597005755917075387 0.7072005565339881672 -1.7231623590258022816 2.9010628568637044644 0.91592978628045274014 0.24982064541240467381 16.31616274487421947 -0.0097185459089828493684 -0.081412897361020794551 -0.0087227075513241578847 0.17762622776113412559 -0.10981487073454661296 0.072743685753200212907 0.8855424576141435189 3.0910034780134543198 0.74543291498070762824 0.11141999105188792052 0.6077017699693857411 12.637116424469134301 -1.4537431375078868623 16.252405243533647905 -0.0075889887996346038282;-0.080267255479585158939 1.3373637172405783424 1.7326298956409422747 7.4704479464701680769 7.4654607468476754661 -0.071541082299281064105 0.1586313562559538981 -5.0316113768307202392 -0.044999607868460168858 -1.792038662416163497 1.4962713465250729872 1.4673491101168709694 2.5113876129064172105 -0.26402148432821109791 -3.5714874348354581635 0.096265618097107596984 3.6921681744920142876 -0.17989129217883392808 0.12072449066571398768 0.033300718331524710447 -0.2145720656570250795 0.6833218402386896928 0.54066124279394467411 -1.8824911013213965205 -0.49325392397070000339 0.24981168891810018318 -0.64029880828481333666 -0.20301517197911084223 -0.34775553006113352206 11.710462091549347363;10.799398974248102689 -15.578471713142404198 10.960649000712738399 -4.9800926525885662599 -4.3790014649860653506 0.41164527768469411084 -3.5664754734606991526 -4.0995951735254152482 -1.2102041003048811252 8.0668325946417276384 -18.559628178641737861 37.889111214827565277 14.259313133126457984 2.4863007037232649488 -7.4588649355575462607 -0.84339414180772387386 0.88722396509414369614 -0.73893933166306213778 2.4623950592373105017 0.81748312957607904838 -6.1037557306533249957 5.6098916445796973562 -7.7752187479728638309 7.0744168712451660497 18.158563106154556266 -0.74280055247075249536 -14.249974346009455672 6.8247134057395353324 11.611857550328464228 0.26916416077814792063;8.118498979383961256 -2.1871949379972313032 12.622279588890236823 6.6484467159262958802 -3.855329513335239433 10.854255332542161128 0.4528091608108659738 -6.2930388845653633112 2.9825071867574797224 10.73547618318177399 0.11848211462982173592 12.174453238363156515 -13.067800845779380836 2.0246190961204830749 3.5014099790563246728 1.6661429484305705362 7.0354163478179883029 -5.6319745342144766909 -0.59792007195215235438 7.9324800627745135628 -34.581901540546091667 -3.8663881311148675657 -0.43750283292774255761 5.3374305313107113236 -3.9320712624871303476 0.21765011412346926822 6.4842058331269196714 -12.277146994505407918 -3.506125321618707158 12.585608503243209455;-9.3003759305115103473 -6.0280665497538459263 -9.2495198398111675431 -7.0656565989432849051 5.8623505967295761465 -7.2786233499018155868 10.04254594364991604 14.541831400791709328 5.1877362888915916628 -5.2718527023178953783 0.12711080252242451527 -6.0144958529015681847 24.964707326090799455 -14.509206284611138926 -26.092738582143287118 0.037250905313074483827 -29.616237248373064261 7.7375128321063959547 13.397639525780167702 -22.555024187525965829 20.615212628071780898 0.86643906108628676588 -18.76964599489729224 -9.7340070734991961388 -11.578738033759362835 -3.3921305900455100968 30.794110564093813309 1.0659243360557710822 -6.7338364071108118836 5.0510748694842568796;-8.7578558160615855854 -11.3291598683642043 -4.0653829539617634126 2.2400814630890524271 -0.44476055206033515699 1.0198558193986988485 9.4056525394359855596 14.186300390950506767 -2.0794414547714388242 4.3182909143135059793 -1.8740886591920400406 -0.74893229569923480682 9.072420884579548428 0.76599936164326953847 -0.22806498086726625929 -1.6230561569109540621 -6.9722102502642115951 2.7169589785655903214 -2.3947060994363766895 5.1574544126170716041 1.8337195948240569976 2.7735182212843092486 -2.0879517798012270369 4.4639965179322684818 4.736375815090626773 -0.076104902103058244545 -9.227548084210285495 -6.4791672983381198847 -5.2108305561897383384 0.57730159428611105277;-2.8642456740122974601 -4.9681234261298605759 -2.3356338196606380997 -0.42593728489616461408 -1.5778356015974401849 -0.45281492174268295203 -10.654084807026064752 -2.2060364430293142313 0.55004431243282159159 -3.0641058495834854192 -0.46074842466590487655 0.49787755970074049072 -0.95574220164768275421 -0.067013676713043368594 -1.6459701978369467579 0.58384454968241195072 0.82833563789869835148 -1.1184433132386444321 0.75035312004200749314 -1.1977324687833692529 -0.74654376971119429385 -1.3747569603483553724 -8.0272234253953289596 -3.096418480993748279 -2.0052286438415904968 -0.22971714609993765244 -1.8521320955578088885 1.1792881200262117503 -2.8203434291661930722 -0.24554942978531921205;-2.4043578130370302226 -13.741796084418281154 6.1534721879824099133 17.792616188700481672 1.1745030792536452768 2.617118704014845143 8.7236541477307447678 21.505128777046305544 -1.4857240299886742552 -4.3466435017545119734 4.3705161226135675889 1.2797734053643361474 3.5156453714999265081 -6.5893480983432271003 3.8051425938931955351 -0.57516661961068649145 -9.9671431183732099868 -0.5422976474341081321 -7.0188018957667592801 15.136682521308157945 8.2916953622117652856 -4.8862869011626131055 0.11087298733157102681 -0.36831942495872233012 -6.2114280919654971669 -13.214663821055726345 -14.768062127667413108 8.8639966708353430391 4.752606966382280973 -1.6691510699412857033;-10.470510830229923016 25.801436245680815063 3.2996919883981585819 -2.9167019901805670834 12.47368064968450696 -1.1149815363738884155 -2.305380988881390536 -4.9218089767759307662 2.7015725685855849214 2.1525015683578940795 4.6949907691536614252 9.6256933186714519479 8.4913173447294116869 2.9307096088670427925 3.6510166940042916295 -0.11964284378194980918 5.6452534692340661238 -4.9673161953170446026 2.3425155798022858633 -7.0699688401972631269 -2.9832152370383964168 -4.3593735324281945864 8.1534291328402304089 1.6444049095066186617 -7.262460974620279508 -0.94673362192717180896 16.251210755497773164 1.9650535423067283514 -14.922668298743245074 0.99540530977514340982;-8.9041017293480617667 23.359344278142494034 -0.84569931978083734414 -4.5779124509502429063 -3.7156853414793293844 1.9413943553125270203 5.7627929435817453196 4.0643126148990562641 2.6991403198267005514 -0.98112231790745152438 -3.5014907635222480842 -6.2629494176058742028 11.6573198923492658 -2.0988202170992242834 -0.0089008088591000754375 -0.23369060548967471314 0.46987596408090526179 -0.39190514504159007503 -1.9758303889666357644 0.89964779081733536881 20.638909706761701557 -3.0919017969615496533 4.9474320618508826897 -1.7937486666387671974 8.1221583446075698021 -12.997171939350934622 2.4742764640098307005 10.282641811085643013 -15.163617045069697653 9.9817027453551414595;-22.345310227703230055 23.385219049142889958 12.71207292669628508 0.56793546434225616881 -5.4218974446138394896 3.1432164742260892965 -2.1661842871091239182 9.5395042718907454571 4.62503107745274189 -0.46420626151948934934 -1.5980136481044893149 13.10800999334393957 0.44196578672091152429 1.006861150809444938 -0.79365091110619812032 -1.6698606861955085368 6.1039507109770552162 -4.1466872381119683766 1.1971307774356192422 7.2855313187258197161 5.4401854929753739043 6.5287905500724470187 4.7842834534361271537 1.558763375397475226 -4.4273034074854074049 3.6365111678857693356 -3.5092572792563534456 -4.8874061739363829915 -24.787464083647190449 0.91104722068809274038;16.787510525326897692 -29.145532422277529605 0.2915146345356119939 7.5227146423953756837 -1.1993683311912213263 -0.1093628193305704599 -2.7532705714999186064 11.07698433168719454 1.3903334385674732676 3.3579520576521231234 1.6586278685475164263 -21.443898925906481168 -9.1922500159617417381 -0.25768054304265353149 6.2729471451382989855 -0.40912591391401692542 -6.0209131431828133429 -27.698566129175876682 0.1857723320700213343 2.0564236318900608325 -0.68960094557664042281 3.0748487355113556241 -6.5649820107305272288 3.4485524299386249858 -12.623747736959151311 0.062844296944394542614 38.855303587937619625 -1.4879135636440461443 54.402999726181647588 3.1881201990470389163;6.7254363280066105091 -2.8980401840372795874 0.80757961823438473292 -5.4275916815571925156 -2.6065029109931430185 0.267569083915689232 2.8846206664639710837 3.8665016748547436087 4.7690039715311094426 -0.22894201651802614794 -14.946797054585900355 -2.0709273268306591653 3.9101975110056717 -0.61143851186851483348 -0.036728100989707704316 1.8283601870020833591 -0.54132654435788940539 -0.45513505962093814272 -1.7250494582376474373 -0.59781198322575224147 4.762726725740866307 -1.0064461692653094982 -1.8685518567627088515 -0.21411880775772765273 4.7538051345401406422 -1.054519176421427451 -12.704824040643481808 7.0082519153162055048 3.2271635026895886256 2.2903966530437509519;33.595414535073373941 4.6538267965367081658 0.31375865460887486513 2.4598973848362102324 -11.055767644798267568 4.0602459645761923568 -0.1881229138303752435 2.2052551418555799145 5.393283929267745691 8.0145251277572118198 -3.5161106922805518415 -14.263789071084737259 -13.604859669299601777 9.71597992507503605 15.443884362729804138 9.3396279714126304583 -8.0725780791668633185 -12.51472610273228625 4.2707956780753280057 -0.93102455449008747479 1.8911378938847867026 2.2528769986352261689 -18.374630898100004828 2.0779365836876269036 0.57163595057582472503 0.9252376710770172652 8.2115259655197867517 -6.1793352672013996951 -31.590962600319457465 -4.6194448901211355718;40.606388818564745691 -29.634509282789629481 7.926530295881139665 -9.2936983084567970081 7.5197483025282538804 -0.92213870131219499715 10.994389220793324924 -7.2631522176711245109 -6.7578068536154294321 -4.3610655387529515536 16.774099553537730856 -0.8056790263532054297 7.7202010620754668579 10.981636968232269425 12.847788533787618093 1.6565269362189960489 4.6249908202560341408 13.627752392863687447 -4.4928353940745529016 -17.429642905068813974 -71.68706620968877985 -12.224327565196839274 19.629392072936312275 -1.6755335962075228462 14.805469141496933716 16.87442695450643626 11.52597010136295097 -16.910396389085285307 -48.894744927456983419 15.883264013524323488;-0.42395231143705369714 0.38138282343979407196 -0.87484733374549572549 -6.4649849543245601069 -0.44609030205658739554 0.014036955499932760386 -0.19234489679554039876 0.0092321736307704564684 -0.062707579008630762174 0.065055078081528078249 0.47947863080366998068 0.058314885925430139102 -0.17571156252066225112 0.0641969568862904294 -1.6667103154260589637 0.038283411815273941936 -0.056768221554042097576 0.0062428348322702709866 0.0078202525928009834072 -0.15417758423451843885 0.029369462552894812224 -0.23853561051548974326 0.11131451002730904931 0.083938935835768446747 -0.013664282505776037188 0.093632640354722740383 -0.48069642374927012973 -0.047968359852579529889 -0.42237278955733742469 -0.077513456004855374459;-9.7078038379470825703 -15.654472506229552664 -2.4069702388292846251 2.2341980620865311558 -5.0179797137570210097 -0.6743612264516835042 -7.9172933428891267837 10.430717025426483602 9.9656817363990839453 -10.013162010562526305 1.6607750140941854866 -4.9156249543293792925 13.351603496873430288 7.2734204065009002704 0.64701860138265432365 0.019265149930096460429 -0.76377500760552941017 -3.2856775197123502252 1.5278363957291156705 -9.5551124057366045861 2.7910640724001591906 -0.33223266046683280761 -4.1726367769769021621 -9.7378036653063908545 -11.368777667668364728 -4.5927845781278477943 -1.9813359478766134902 -13.464669559469255589 -20.552620907890275959 0.012617674726179965716;3.2945525078887554216 9.2390549426187398296 0.6859667671383867793 -3.148285897833300595 4.7094038031829885682 -0.95387308059039210839 4.1177225884647157272 -8.4470050605723248083 9.7730493671704756764 -6.8047530837652807634 9.6524276140738738405 7.9563258183147098634 -5.1381229953045508552 -2.213293821770937253 -1.0156933024975671742 -0.25231671482964246334 0.66310222736297952384 -0.72939241769680662753 1.0485965308445803768 -2.2204649919039596284 -2.4468136963611177848 2.2849126475423511273 1.1887703647386702599 -7.438016769430562114 0.69884345706507733365 -2.9022497568966554304 4.0577728815137135143 0.96676061745755592636 -0.36968707688038299208 0.66656018028912555895;-16.456359922450992883 -2.5004806045119805091 2.46106217998047061 0.65443304830693038721 21.08157884152389272 -3.7673670057239312392 12.459514157733929451 35.695915274649699711 2.0410876905993635688 0.63788333448635281542 11.630971671069399775 11.090388477766760289 -2.5543449100536377294 2.0653728395007329155 -11.066441690498844963 4.0039595090151083312 -0.25361663162392772408 0.22008918382161699046 2.6115603693412827724 13.39629871718470433 -0.28072304507959239261 -5.1957538421156090891 -10.711326292757062717 -0.9006658109502887477 -1.859094028082338923 2.6387733362109764279 -1.0281305291100739652 -3.4373805786529816331 -9.5977533123586731278 2.5394919973423362158;79.298646240843069677 -16.650342814690901605 -1.4935965120323717592 -1.1294228568630517717 14.791296158427684304 -8.2177506280897585356 25.162248687866558328 17.866545256000332387 -11.47991634117771298 29.183878533909762609 -0.046779895963860805563 -3.3326057962872295271 -0.0068098230688197055813 -9.6813884929575237948 32.105743524609160033 -4.2574216970261735682 -4.1689726417744630282 8.9956849815505854906 4.8283387386320200108 -11.045346934329280941 -58.049015178779008295 -0.4407545750061723222 21.531150449836310656 1.6250279491046450975 5.7104032761255663075 9.1662495992860204552 -67.044917163759748746 61.853524303644924487 31.592128204830075333 6.4900505739054983323];

% Layer 3
b3 = 61.657508328633184647;
LW3_2 = [-9.5151943294303329424 30.03018540280800508 -1.2474849447214153564 0.31469066255090055728 -0.4822880765029318173 -1.8177498885741503187 -3.8685693250891812767 0.94354605370732069769 1.124994410603206596 0.78120434383725056993 -0.87441260999754633065 -33.980363172424361551 -1.0059745589564081936 0.99351880237805545448 0.7257512670545293032 16.09293964893647555 1.0548348374684006767 1.0089845504591745673 4.6927087113458192391 -0.58697262916739534333];

% ===== SIMULATION ========

% Dimensions
Q = size(x1,2); % samples

% Input 1
xp1 = mapminmax_apply(x1,x1_step1);

% Layer 1
a1 = tansig_apply(repmat(b1,1,Q) + IW1_1*xp1);

% Layer 2
a2 = tansig_apply(repmat(b2,1,Q) + LW2_1*a1);

% Layer 3
a3 = repmat(b3,1,Q) + LW3_2*a2;

% Output 1
y1 = a3;
end

% ===== MODULE FUNCTIONS ========

% Map Minimum and Maximum Input Processing Function
function y = mapminmax_apply(x,settings)
  y = bsxfun(@minus,x,settings.xoffset);
  y = bsxfun(@times,y,settings.gain);
  y = bsxfun(@plus,y,settings.ymin);
end

% Sigmoid Symmetric Transfer Function
function a = tansig_apply(n,~)
  a = 2 ./ (1 + exp(-2*n)) - 1;
end
