package user;

import java.io.Serializable;

import server.parser.Formula;

/**
 * Wrapper-Klasse, um Formeln mit den dazugehoerigen IDs aus der Datenbank als ein Objekt darzustellen.
 */
public class IdAndFormula implements Serializable {
	private static final long serialVersionUID = 2627764940117837859L;
	
	public static final int TYPE_LOG = 1;
	public static final int TYPE_CONF_POL = 2;
	public static final int TYPE_PRIOR = 3;
	
	private int id;
	private Formula formula = null;
	private String formulaString = null;
	
	public IdAndFormula( int id, Formula formula ) {
		this.id = id;
		this.formula = formula;
		
		if ( formula != null ) {
			this.formulaString = formula.toString();
		} else {
			this.formulaString = null;
		}
	}
	
	public int getId() {
		return this.id;
	}
	
	public Formula getFormula() {
		return this.formula;
	}
	
	public void setId( int id ) {
		this.id = id;
	}
	
	public void setFormula( Formula formula ) {
		this.formula = formula;
		
		if ( formula != null ) {
			this.formulaString = formula.toString();
		} else {
			this.formulaString = null;
		}	}
	
	public String toString() {
		return this.formulaString;
		//return "ID: "+this.id + " Formula: "+this.formulaString;
	}
}
