package server.util;

/**
 * A class can implement this interface when it wants to be informed
 * of changes in objects extending {@link Observer}.
 *
 * @param <S> Type of the class that is observed.
 * @param <D> Must be the same type as the object you want to observe.
 */
public interface Observer<S extends Observable<S,D>, D> {

	public void update( Observable<S,D> observable, Observable.Action action, D data );
}
