package server.theoremprover;

import exception.ProverException;


public abstract class ProverResult {

	protected boolean result;
	
	protected String output;
	
	public ProverResult(boolean result, String output) {
		this.result = result;
		this.output = output;
	}
	
	public boolean getResult() {
		return result;
	}
	
	public String getRawOutput() {
		return output;
	}
	
	public abstract String getProof() throws ProverException;
	
	public abstract String getProofAsXML() throws ProverException;
}
