package server.parser.node;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import server.parser.Formatter.FormulaFormatter;


/**
 * Node, die eine Variable repräsentiert.
 * 
 * Die VariableNode besitzt keine Kinder.
 */
public class VariableNode extends TermNode {
	private static final long serialVersionUID = 8527482311371304685L;
	
	String variable = null;

	public VariableNode( String variableLiteral ) {
		this.setVariable( variableLiteral );
	}

	public String getVariable() {
		return this.variable;
	}
	
	public void setVariable( String variable ) {
		this.variable = variable;
	}

	@Override
	public boolean isVariableNode() {
		return true;
	}

	public String toString(FormulaFormatter formulaformatter) {
		return getVariable();
	}

	@Override
	public void renameVariables(Map<String, String> mapping) {
		String variable = getVariable();
		if (mapping.keySet().contains(variable)) { 
			// falls das zu ersetzende Literal gefunden, dann ersetzen
			this.setVariable( mapping.get(variable) );
		}
	}
	
	public Set<String> rr() {
		Set<String> rr = new HashSet<String>();
		rr.add(getVariable());
		return rr;
	}

	/**
	 * Ersetzt die durch die im Key als String spezifizierten freien Variablen durch 
	 * die als Value angegebene ConstantNode.
	 * 
	 * @param mapping Abbildung: Varialbenname -> Konstante
	 */
	@Override
	public void substituteVariables(Map<String, String> mapping) {
		String variable = getVariable();
		if (mapping.keySet().contains(variable)) {
			// falls diese Variable durch eine Konstante substituiert werden soll
			
			// VariableNode besitzt keine Kinder, also muss sich nicht um dessen Umhängen gekümmert werden
			this.replace( new StringNode(mapping.get(variable)) );
		}
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = super.hashCode();
		result = prime * result
				+ ((variable == null) ? 0 : variable.hashCode());
		return result;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (!super.equals(obj))
			return false;
		if (getClass() != obj.getClass())
			return false;
		VariableNode other = (VariableNode) obj;
		if (variable == null) {
			if (other.variable != null)
				return false;
		} else if (!variable.equals(other.variable))
			return false;
		return true;
	}	
}
