package server.parser.node;

import java.util.List;

import exception.UnsupportedFormulaException;

import server.parser.Formatter.FormulaFormatter;

public class UniversalQuantifiedNode extends QuantifiedNode {
	private static final long serialVersionUID = 5814050505380222904L;

	public UniversalQuantifiedNode(List<VariableNode> quantifiedVariables, Node quantifyingFormula) {
		super(quantifiedVariables, quantifyingFormula);
	}

	@Override
	public boolean isUniversalQuantifiedNode() {
		return true;
	}

	@Override
	public String getQuantor(FormulaFormatter formatter) {
		return formatter.getUniversalQuantor();
	}
	
	@Override
	protected void pushNegations( boolean foundNegation, boolean skipNegatedExistentialQuantifiers ) throws UnsupportedFormulaException {
		if ( foundNegation ) {
			// Negation vor Allquantor => Existenzquantor
			ExistentialQuantifiedNode exists = new ExistentialQuantifiedNode( this.getVariableNodes(), this.getQuantifiedFormula() );
			this.getParent().replaceChild(this, exists);
		}
		
		// Rekursiver Aufruf
		for ( Node child : this.getChildren() ) {
			child.pushNegations(foundNegation, skipNegatedExistentialQuantifiers);
		}
	}

}
