package server.parser.node;

import java.util.HashSet;
import java.util.Set;

import server.parser.Formatter.FormulaFormatter;

public abstract class ConstantNode extends TermNode {
	private static final long serialVersionUID = -7802788485498884305L;
	
	private final String constant;
	
	public ConstantNode( String constant ) {
		this.constant = constant;
	}
	
	public String getConstant() {
		return this.constant;
	}
	
	@Override
	public boolean isConstantNode() {
		return true;
	}
	
	@Override
	public String toString(FormulaFormatter formulaformatter) {
		return formulaformatter.processString( this.getConstant() );
	}
	
	@Override
	public Set<String> rr() {
		Set<String> rr = new HashSet<String>();
		return rr;
	}
	
	/**
     * Gibt die Menge aller Konstanten zurueck, die in diesem Baum vorkommen.
     * 
     * @return Die Menge aller Konstanten dieses (Teil-)Baums.
     */
	@Override
	public Set<String> getConstants() {
		Set<String> ret = new HashSet<String>();
		ret.add(this.getConstant());
		return ret;
	}
	
	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((constant == null) ? 0 : constant.hashCode());
		return result;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		ConstantNode other = (ConstantNode) obj;
		if (constant == null) {
			if (other.constant != null)
				return false;
		} else if (!constant.equals(other.constant))
			return false;
		return true;
	}
}
