package server.parser.node;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import server.parser.Formatter.FormulaFormatter;


public abstract class ConnectorNode extends Node {
	private static final long serialVersionUID = -8796096006258485951L;

	/**
	 * Liefert die Liste aller Operanden zurueck.
	 * Identisch mit der Liste aller Kinder.
	 * 
	 * @return
	 */
	public List<Node> getOperands() {
		return getChildren();
	}
	
	public void addOperand(Node operand) {
		addChild(operand);
	}
	
	@Override
	public boolean isConnectorNode() {
		return true;
	}

	protected String getJunctor(FormulaFormatter formatter) {
		return "";
	}
	
	@Override
	public String toString(FormulaFormatter formulaformatter) {
		StringBuilder builder = new StringBuilder();
		
		String separator = "";
		for ( Node child : this.getChildren() ) {
			builder.append( separator );
			builder.append( child.toString(formulaformatter) );
			separator = SPACE + this.getJunctor(formulaformatter) + SPACE;
		}
		
		if ( this.getParent().isRootNode() ) {
			// Wurzelknoten (Kind von RootNode).
			return builder.toString();
		} else {
			return "("+builder.toString()+")";
		}
	}
	
	@Override
	public boolean isElementaryFormula() {
		return (getOperands().size() == 1) && (getChild(0).isElementaryFormula());
	}
	
	public boolean isStrictConnective() {
		return getOperands().size() > 1;
	}
	
	@Override
	public Set<String> rr() {
		throw new UnsupportedOperationException("Verknuepfte Formel: rr ist berechenbar nur für Disj. und Konj.");
	}

	/**
	 * Liefert das einzige Kind zurueck. Wenn es mehr als Kind gibt
	 * wird eine Exception ausgeloest.
	 */
	protected Node getUniqueOperand() {
		if (!isStrictConnective()) {
			return getOperands().iterator().next();
		}
		throw new UnsupportedOperationException("Strict connective: " + getOperands().size() + " Operands");
	}
	
	/**
	 * Wird von ConjunctorNode und DisjunctorNode verwendet, um flatten() uu implementieren.
	 * Dabei werden Kinder gleichen Typs geloescht und dessen Kinder in den aktuellen Knoten uebernommen.
	 * 
	 * @return Aktueller Knoten, bei dem kein Kind den gleichen Knotentyp wie der aktuelle Knoten hat.
	 */
	protected Node makeFlat() {
		ArrayList<Node> newChildren = new ArrayList<Node>();

		for ( Node child : this.getChildren() ) {
			// Rekursiv flatten().
			child = child.flatten();

			// Gleiche Klassentypen verschachtelt? => aufloesen.
			if ( child.getClass().equals(this.getClass()) ) {
				newChildren.addAll( child.getChildren() );
			} else {
				// Ansonsten einfach Kind uebernehmen.
				newChildren.add( child );
			}
		}

		// Neue Kindliste uebernehmen
		this.replaceChildren( newChildren );

		return this;
	}
}
