package server.parser.node;

import server.parser.Formatter.FormulaFormatter;

public class AtomicKripkeNode extends Node {
	private static final long serialVersionUID = 3128436861886020822L;

	public AtomicKripkeNode(Node knowledgeformula) {
		addChild(knowledgeformula);
	}
	
	@Override
	public boolean isAtomicKripkeNode() {
		return true;
	}
	
	/**
	 * liefert die Wissensformel zurueck
	 * */
	public Node getKnowledgeFormula() {
		return getChild(0);
	}
	
	@Override
	public String toString(FormulaFormatter formulaformatter) {
		StringBuilder builder = new StringBuilder();
		builder.append("K");
		builder.append("{");
		builder.append(getKnowledgeFormula().toString(formulaformatter));
		builder.append("}");
		return builder.toString(); 
	}

}
