/* Generated By:JavaCC: Do not edit this line. Parser.java */
package server.parser;

import java.util.HashSet;
import java.util.Set;
import java.util.List;
import java.util.ArrayList;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.Vector;

import server.parser.node.*;
import communication.CqeType;

@SuppressWarnings("all")

public class Parser implements ParserConstants {
        /**
	 * Liest eine Eingabe (Interaktion) ein und initialisiert den Parser.
	 * Die eigentliche Umwandlung wird in der Methode getFormula() durchgefuehrt.
	 */
    public Parser( String interaction ) {
        this( new BufferedReader(new StringReader( interaction )) );
    }

/**
 * Mindestens ein Leerzeichen.
 */
  final public void spaces() throws ParseException {
    label_1:
    while (true) {
      jj_consume_token(SPACE);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
        ;
        break;
      default:
        jj_la1[0] = jj_gen;
        break label_1;
      }
    }
  }

/**
 * Optionale Leerzeichenfolge.
 */
  final public void optional_spaces() throws ParseException {
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
        ;
        break;
      default:
        jj_la1[1] = jj_gen;
        break label_2;
      }
      jj_consume_token(SPACE);
    }
  }

/**
 * Atom = aussagenlogische Variable oder praedikatenlogisches Atom.
 */
  final public AtomPredicateNode atom() throws ParseException {
                             AtomPredicateNode atom;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PROPOSITIONALNAME:
      atom = propositionalAtom();
      break;
    case RELATIONNAME:
      atom = firstOrderAtom();
      break;
    default:
      jj_la1[2] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return atom;}
    throw new Error("Missing return statement in function");
  }

/**
 * Grundatom = aussagenlogische Variable oder praedikatenlogisches Grundatom.
 */
  final public AtomPredicateNode groundedAtom() throws ParseException {
                                     AtomPredicateNode atom;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PROPOSITIONALNAME:
      atom = propositionalAtom();
      break;
    case RELATIONNAME:
      atom = groundedFirstOrderAtom();
      break;
    default:
      jj_la1[3] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return atom;}
    throw new Error("Missing return statement in function");
  }

/**
 * Aussagenlogische Variable.
 */
  final public AtomPredicateNode propositionalAtom() throws ParseException {
                                          Token t;
    t = jj_consume_token(PROPOSITIONALNAME);
      {if (true) return new AtomPredicateNode(t.image);}
    throw new Error("Missing return statement in function");
  }

/**
 * Praedikatenlogisches Atom (mit Variablen und/oder Konstanten).
 */
  final public AtomPredicateNode firstOrderAtom() throws ParseException {
                                      Token t; TermNode para; AtomPredicateNode atom = null;
    t = jj_consume_token(RELATIONNAME);
      atom = new AtomPredicateNode(t.image.substring(0,t.image.length()-1));
    para = parameter();
    optional_spaces();
      atom.addParameter(para);
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[4] = jj_gen;
        break label_3;
      }
      jj_consume_token(COMMA);
      optional_spaces();
      para = parameter();
      optional_spaces();
        atom.addParameter(para);
    }
    jj_consume_token(RIGHT_PARENTHESIS);
      {if (true) return atom;}
    throw new Error("Missing return statement in function");
  }

/**
 * Praedikatenlogisches Grundatom (mit Variablen und/oder Konstanten).
 */
  final public AtomPredicateNode groundedFirstOrderAtom() throws ParseException {
                                               TermNode konst; Token t; AtomPredicateNode atom;
    t = jj_consume_token(RELATIONNAME);
      atom = new AtomPredicateNode(t.image.substring(0,t.image.length()-1));
    konst = constant();
    optional_spaces();
      atom.addParameter(konst);
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[5] = jj_gen;
        break label_4;
      }
      jj_consume_token(COMMA);
      optional_spaces();
      konst = constant();
      optional_spaces();
        atom.addParameter(konst);
    }
    jj_consume_token(RIGHT_PARENTHESIS);
      {if (true) return atom;}
    throw new Error("Missing return statement in function");
  }

/**
 * Grundliteral. Grundatom, bei dem ggf. eine Negation vorangestellt ist.
 */
  final public Node groundedLiteral() throws ParseException {
                           Node atom;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case RELATIONNAME:
    case PROPOSITIONALNAME:
      atom = groundedAtom();
      {if (true) return atom;}
      break;
    case NOT:
      jj_consume_token(NOT);
      atom = groundedAtom();
      {if (true) return new NegationNode(atom);}
      break;
    default:
      jj_la1[6] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parameter eines praedikatenlogischen Atoms (eine Variable oder eine Konstante).
 */
  final public TermNode parameter() throws ParseException {
                         TermNode retVal = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case B_STRING:
      retVal = parameter_var();
      break;
    case BOOLEAN:
    case CONSTANT_STRING:
    case NUMBER:
      retVal = constant();
      break;
    default:
      jj_la1[7] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
          {if (true) return retVal;}
    throw new Error("Missing return statement in function");
  }

/**
 * Praedikatenlogische Variable.
 */
  final public VariableNode parameter_var() throws ParseException {
                                Token t;
    t = jj_consume_token(B_STRING);
      {if (true) return new VariableNode( t.image );}
    throw new Error("Missing return statement in function");
  }

/**
 * Konstante. Kann String in Anfuehrungszeichen, Zahlen oder ein boolscher Wert (TRUE oder FALSE) sein.
 */
  final public ConstantNode constant() throws ParseException {
                           Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CONSTANT_STRING:
      t = jj_consume_token(CONSTANT_STRING);
      // Anfuehrungszeichen am Anfang und Ende des String loeschen.
      String str = t.image.substring(1,t.image.length()-1);
      {if (true) return new StringNode(str);}
      break;
    case NUMBER:
      t = jj_consume_token(NUMBER);
      {if (true) return new IntegerNode(t.image);}
      break;
    case BOOLEAN:
      t = jj_consume_token(BOOLEAN);
      {if (true) return new BooleanNode(t.image);}
      break;
    default:
      jj_la1[8] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Gleichheit und Ungleichheit.
 */
  final public EqualityNode equality() throws ParseException {
                            TermNode left = null; TermNode right = null; boolean equals = false;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case B_STRING:
      left = parameter_var();
      break;
    case BOOLEAN:
    case CONSTANT_STRING:
    case NUMBER:
      left = constant();
      break;
    default:
      jj_la1[9] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    optional_spaces();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EQUALITY:
      jj_consume_token(EQUALITY);
                       equals = true;
      break;
    case NOTEQUALITY:
      jj_consume_token(NOTEQUALITY);
                                                          equals = false;
      break;
    default:
      jj_la1[10] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    optional_spaces();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case B_STRING:
      right = parameter_var();
      break;
    case BOOLEAN:
    case CONSTANT_STRING:
    case NUMBER:
      right = constant();
      break;
    default:
      jj_la1[11] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
          {if (true) return new EqualityNode( left, right, equals );}
    throw new Error("Missing return statement in function");
  }

/**
 * Liste mit Variablen eines Quantors.
 */
  final public ArrayList<VariableNode> quantorVariables() throws ParseException {
  ArrayList<VariableNode> vars = new ArrayList<VariableNode>();
  Token t;
    t = jj_consume_token(B_STRING);
                   vars.add( new VariableNode(t.image) );
    optional_spaces();
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[12] = jj_gen;
        break label_5;
      }
      jj_consume_token(COMMA);
      optional_spaces();
      t = jj_consume_token(B_STRING);
                     vars.add( new VariableNode(t.image) );
      optional_spaces();
    }
    {if (true) return vars;}
    throw new Error("Missing return statement in function");
  }

/**
 * Wurzel einer praedikatenlogischen Formel.
 */
  final public Node firstOrderFormula() throws ParseException {
                             Node retVal;
    retVal = term1();
      {if (true) return retVal;}
    throw new Error("Missing return statement in function");
  }

  final public Node term1() throws ParseException {
  Node t2;
  ArrayList<Node> children = new ArrayList<Node>();
  Token j_equiv;
    t2 = term2();
      children.add( t2 );
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EQUIV:
      j_equiv = jj_consume_token(EQUIV);
      t2 = term2();
        children.add( t2 );
      break;
    default:
      jj_la1[13] = jj_gen;
      ;
    }
        // Nur "echte" Knoten einfuegen (Dirk)
        if ( children.size() == 1 )
                {if (true) return t2;}
        else
        {
          EquivalenceNode retVal = new EquivalenceNode();
          retVal.addChildren( children );
              {if (true) return retVal;}
            }
    throw new Error("Missing return statement in function");
  }

  final public Node term2() throws ParseException {
  Node t3;
  ArrayList<Node> children = new ArrayList<Node>();
    t3 = term3();
      children.add( t3 );
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IMPL:
      jj_consume_token(IMPL);
      t3 = term3();
        children.add( t3 );
      break;
    default:
      jj_la1[14] = jj_gen;
      ;
    }
        // Nur "echte" Knoten einfuegen (Dirk)
        if ( children.size() == 1 )
                {if (true) return t3;}
        else
        {
          ImplicationNode retVal = new ImplicationNode();
          retVal.addChildren( children );
              {if (true) return retVal;}
                }
    throw new Error("Missing return statement in function");
  }

  final public Node term3() throws ParseException {
  ArrayList<Node> children = new ArrayList<Node>();
  Node t4;
    t4 = term4();
     children.add( t4 );
    label_6:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OR:
        ;
        break;
      default:
        jj_la1[15] = jj_gen;
        break label_6;
      }
      jj_consume_token(OR);
      t4 = term4();
        children.add( t4 );
    }
        // Nur "echte" Knoten einfuegen (Dirk)
        if ( children.size() == 1 )
                {if (true) return t4;}
        else
        {
          DisjunctorNode retVal = new DisjunctorNode();
          retVal.addChildren( children );
              {if (true) return retVal;}
            }
    throw new Error("Missing return statement in function");
  }

  final public Node term4() throws ParseException {
  ArrayList<Node> children = new ArrayList<Node>();
  Node t5;
    t5 = term5();
      children.add( t5 );
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AND:
        ;
        break;
      default:
        jj_la1[16] = jj_gen;
        break label_7;
      }
      jj_consume_token(AND);
      t5 = term5();
       children.add( t5 );
    }
        // Nur "echte" Knoten einfuegen (Dirk)
        if ( children.size() == 1 )
                {if (true) return t5;}
        else
        {
          Node retVal = new ConjunctorNode();
          retVal.addChildren( children );
              {if (true) return retVal;}
                }
    throw new Error("Missing return statement in function");
  }

  final public Node term5() throws ParseException {
                 ArrayList<VariableNode> vars; Node t5, t6;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LEFT_PARENTHESIS:
    case BOOLEAN:
    case CONSTANT_STRING:
    case NUMBER:
    case RELATIONNAME:
    case PROPOSITIONALNAME:
    case B_STRING:
      t6 = term6();
      {if (true) return t6;}
      break;
    case NOT:
      jj_consume_token(NOT);
      t5 = term5();
      {if (true) return new NegationNode(t5);}
      break;
    case FORALL:
      jj_consume_token(FORALL);
      vars = quantorVariables();
      t5 = term5();
      {if (true) return new UniversalQuantifiedNode(vars,t5);}
      break;
    case EXISTS:
      jj_consume_token(EXISTS);
      vars = quantorVariables();
      t5 = term5();
      {if (true) return new ExistentialQuantifiedNode(vars,t5);}
      break;
    default:
      jj_la1[17] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Node term6() throws ParseException {
                 Node node;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case RELATIONNAME:
    case PROPOSITIONALNAME:
      node = atom();
      break;
    case BOOLEAN:
    case CONSTANT_STRING:
    case NUMBER:
    case B_STRING:
      node = equality();
      break;
    case LEFT_PARENTHESIS:
      jj_consume_token(LEFT_PARENTHESIS);
      optional_spaces();
      node = term1();
      optional_spaces();
      jj_consume_token(RIGHT_PARENTHESIS);
      break;
    default:
      jj_la1[18] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return node;}
    throw new Error("Missing return statement in function");
  }

/**
 * Praedikatenlogische Anfrage.
 */
  final public Node pquery() throws ParseException {
                  Node formula;
    jj_consume_token(QUERY);
    optional_spaces();
    jj_consume_token(LEFT_PARENTHESIS);
    optional_spaces();
    formula = firstOrderFormula();
    optional_spaces();
    jj_consume_token(RIGHT_PARENTHESIS);
    {if (true) return formula;}
    throw new Error("Missing return statement in function");
  }

  final public Node provider_update() throws ParseException {
                           Node liter;
    jj_consume_token(PROVIDER_UPDATE);
    optional_spaces();
    jj_consume_token(LEFT_PARENTHESIS);
    optional_spaces();
    liter = groundedLiteral();
    optional_spaces();
    jj_consume_token(RIGHT_PARENTHESIS);
    {if (true) return liter;}
    throw new Error("Missing return statement in function");
  }

  final public Node provider_update_transaction() throws ParseException {
                                       Node liter; Vector<Node> literals = new Vector<Node>();
    jj_consume_token(PROVIDER_UPDATE_TRAN);
    optional_spaces();
    jj_consume_token(LEFT_PARENTHESIS);
    optional_spaces();
    liter = groundedLiteral();
                              literals.add( liter );
    label_8:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[19] = jj_gen;
        break label_8;
      }
      jj_consume_token(COMMA);
      optional_spaces();
      liter = groundedLiteral();
                                    literals.add( liter );
      optional_spaces();
    }
    jj_consume_token(RIGHT_PARENTHESIS);
    {if (true) return new LiteralSequenceNode(literals, true);}
    throw new Error("Missing return statement in function");
  }

  final public Node view_update() throws ParseException {
                       Node liter;
    jj_consume_token(VIEW_UPDATE);
    optional_spaces();
    jj_consume_token(LEFT_PARENTHESIS);
    optional_spaces();
    liter = groundedLiteral();
    optional_spaces();
    jj_consume_token(RIGHT_PARENTHESIS);
    {if (true) return liter;}
    throw new Error("Missing return statement in function");
  }

  final public Node view_update_transaction() throws ParseException {
                                   Node liter; Vector<Node> literals = new Vector<Node>();
    jj_consume_token(VIEW_UPDATE_TRAN);
    optional_spaces();
    jj_consume_token(LEFT_PARENTHESIS);
    optional_spaces();
    liter = groundedLiteral();
                              literals.add( liter );
    label_9:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[20] = jj_gen;
        break label_9;
      }
      jj_consume_token(COMMA);
      optional_spaces();
      liter = groundedLiteral();
                                    literals.add( liter );
      optional_spaces();
    }
    jj_consume_token(RIGHT_PARENTHESIS);
    {if (true) return new LiteralSequenceNode(literals, true);}
    throw new Error("Missing return statement in function");
  }

/**
 * Menge mit Atomen, die bei einem Update veraendert wurden.
 */
  final public Set<AtomPredicateNode> updateSet() throws ParseException {
                                       AtomPredicateNode atom; Set<AtomPredicateNode> atoms = new HashSet<AtomPredicateNode>();
    jj_consume_token(LEFT_CURLY_BRACE);
    optional_spaces();
    atom = atom();
                  atoms.add( atom );
    optional_spaces();
    label_10:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[21] = jj_gen;
        break label_10;
      }
      jj_consume_token(COMMA);
      optional_spaces();
      atom = atom();
                        atoms.add( atom );
      optional_spaces();
    }
    jj_consume_token(RIGHT_CURLY_BRACE);
    {if (true) return atoms;}
    throw new Error("Missing return statement in function");
  }

// Parst eine beliebige Interatkion (Query, Update) ein.
  final public void parseInteraction(Formula formula) throws ParseException {
                                             CqeType.InteractionType type; Node interaction;
    label_11:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case QUERY:
        interaction = pquery();
                             type = CqeType.InteractionType.QUERY;
        break;
      case PROVIDER_UPDATE:
        interaction = provider_update();
                                        type = CqeType.InteractionType.PROVIDER_UPDATE;
        break;
      case PROVIDER_UPDATE_TRAN:
        interaction = provider_update_transaction();
                                                    type = CqeType.InteractionType.PROVIDER_UPDATE_TRANSACTION;
        break;
      case VIEW_UPDATE:
        interaction = view_update();
                                    type = CqeType.InteractionType.VIEW_UPDATE;
        break;
      case VIEW_UPDATE_TRAN:
        interaction = view_update_transaction();
                                                type = CqeType.InteractionType.VIEW_UPDATE_TRANSACTION;
        break;
      case LEFT_PARENTHESIS:
      case NOT:
      case FORALL:
      case EXISTS:
      case BOOLEAN:
      case CONSTANT_STRING:
      case NUMBER:
      case RELATIONNAME:
      case PROPOSITIONALNAME:
      case B_STRING:
        interaction = firstOrderFormula();
                                          type = CqeType.InteractionType.NONE;
        break;
      default:
        jj_la1[22] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LEFT_PARENTHESIS:
      case NOT:
      case FORALL:
      case EXISTS:
      case QUERY:
      case PROVIDER_UPDATE:
      case PROVIDER_UPDATE_TRAN:
      case VIEW_UPDATE:
      case VIEW_UPDATE_TRAN:
      case BOOLEAN:
      case CONSTANT_STRING:
      case NUMBER:
      case RELATIONNAME:
      case PROPOSITIONALNAME:
      case B_STRING:
        ;
        break;
      default:
        jj_la1[23] = jj_gen;
        break label_11;
      }
    }
    jj_consume_token(0);
    formula.setRootChild( interaction ); formula.setInteractionType(type);
  }

  /** Generated Token Manager. */
  public ParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private int jj_gen;
  final private int[] jj_la1 = new int[24];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x0,0x0,0x30000000,0x30000000,0x100,0x100,0x30001000,0x4e000000,0xe000000,0x4e000000,0xc0,0x4e000000,0x100,0x10000,0x8000,0x4000,0x2000,0x7e061002,0x7e000002,0x100,0x100,0x100,0x7efe1002,0x7efe1002,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x10,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }

  /** Constructor with InputStream. */
  public Parser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public Parser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new ParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 24; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 24; i++) jj_la1[i] = -1;
  }

  /** Constructor. */
  public Parser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new ParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 24; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 24; i++) jj_la1[i] = -1;
  }

  /** Constructor with generated Token Manager. */
  public Parser(ParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 24; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(ParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 24; i++) jj_la1[i] = -1;
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[37];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 24; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 37; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

}
