package server.parser.Formatter;

public class StandardFormatter implements FormulaFormatter {
	/**
	 * liefert die Equivalenzsymbol in dem definierten Format zuerueck
	 * */
	public String getEquivalence() {
		return "EQUIV";
	}
	
	/**
	 * liefert die Implikationssymbol in dem definierten Format zuerueck
	 * */
	public String getImplication() {
		return "IMPL";
	}

	/**
	 * liefert die Disjunktorssymbol in dem definierten Format zuerueck
	 * */	
	public String getDisjunctor() {
		return "OR";
	}

	/**
	 * liefert die Konjunktorssymbol in dem definierten Format zuerueck
	 * */		
	public String getConjunctor() {
		return "AND";
	}
	
	public String getUniversalQuantor() {
		return "FORALL";
	}
	
	public String getExistialQuantor() {
		return "EXISTS";
	}
	
	public String getQuantorSeperator( String quantor ) {
		return ",";
	}

	/**
	 * liefert die Konjunktorssymbol in dem definierten Format zuerueck
	 * */			
	public String getBeforeNegation() {
		return "NOT";
	}
	
	public String getAfterNegation() {
		return "";
	}
	
	public String getLeftParenthesis() {
		return "(";
	}
	
	public String getRightParenthesis() {
		return ")";
	}
	
	public String getEquals() {
		return "=";
	}
	
	public String getNotEquals() {
		return "!=";
	}

	/**
	 * verarbeitet die eingegebene Zeichenkette nach dem definierten Format und liefert sie zuerueck
	 * */	
	public String processString(String input) {
		return "\""+input+"\"";
	}

	/**
	 * verarbeitet die eingegebene Zahl nach dem definierten Format und liefert sie zuerueck
	 * */		
	public String processNumber(String number) {
		return number;
	}

	/**
	 * verarbeitet die eingegebene boolschen Wert nach dem definierten Format und liefert sie zuerueck
	 * */	
	public String processBoolean(String bool) {
		return bool;
	}

	@Override
	public String getBeforeLiteralSequence() {
		return "<";
	}
	
	@Override
	public String getAfterLiteralSequence() {
		return ">";
	}

	@Override
	public String getMum() {
		return "mum";
	}
}
