package server.parser.Formatter;

public class ProverNineFormatter extends StandardFormatter {
	
	/**
	 * liefert die Equivalenzsymbol in dem definierten Format zuerueck
	 * */
	public String getEquivalence() {
		return "<->";
	}
	
	/**
	 * liefert die Implikationssymbol in dem definierten Format zuerueck
	 * */
	public String getImplication() {
		return "->";
	}

	/**
	 * liefert die Disjunktorssymbol in dem definierten Format zuerueck
	 * */	
	public String getDisjunctor() {
		return "|";
	}

	/**
	 * liefert die Konjunktorssymbol in dem definierten Format zuerueck
	 * */		
	public String getConjunctor() {
		return "&";
	}
	
	public String getUniversalQuantor() {
		return "all";
	}
	
	public String getExistialQuantor() {
		return "exists";
	}
	
	public String getQuantorSeperator( String quantor ) {
		return " "+quantor+" ";
	}

	/**
	 * liefert die Konjunktorssymbol in dem definierten Format zuerueck
	 * */			
	public String getBeforeNegation() {
		return "- (";
	}
	
	public String getAfterNegation() {
		return ")";
	}
	
	@Override
	public String processNumber( String number ) {
		return "\"" + number + "\"";
	}
	
	@Override
	public String processBoolean( String bool ) {
		return "\"" + bool + "\"";
	}
}
