package server.parser.Formatter;

/**
 * Die Schnittstelle: Formelformatter
 * */
public interface FormulaFormatter {
	
	/**
	 * liefert die Equivalenzsymbol in dem definierten Format zuerueck
	 * */
	public String getEquivalence();
	
	/**
	 * liefert die Implikationssymbol in dem definierten Format zuerueck
	 * */
	public String getImplication();

	/**
	 * liefert die Disjunktorssymbol in dem definierten Format zuerueck
	 * */	
	public String getDisjunctor();

	/**
	 * liefert die Konjunktorssymbol in dem definierten Format zuerueck
	 * */		
	public String getConjunctor();

	/**
	 * liefert die Konjunktorssymbol in dem definierten Format zuerueck
	 * */			
	public String getBeforeNegation();
	public String getAfterNegation();
	
	public String getUniversalQuantor();
	public String getExistialQuantor();
	public String getQuantorSeperator( String quantor );
	
	public String getLeftParenthesis();
	public String getRightParenthesis();
	
	public String getEquals();
	public String getNotEquals();

	/**
	 * Wird fuer Sequenzen von Literalen bei Updates verwendet.
	 */
	public String getBeforeLiteralSequence();
	public String getAfterLiteralSequence();
	
	/**
	 * Symbol um eine MumFormula zu repraesentieren.
	 * @return
	 */
	public String getMum();
	
	/**
	 * verarbeitet die eingegebene Zeichenkette nach dem definierten Format und liefert sie zuerueck
	 * */	
	public String processString(String input);

	/**
	 * verarbeitet die eingegebene Zahl nach dem definierten Format und liefert sie zuerueck
	 * */		
	public String processNumber(String number);

	/**
	 * verarbeitet die eingegebene boolschen Wert nach dem definierten Format und liefert sie zuerueck
	 * */	
	public String processBoolean(String bool);	
}
