package server.database.sql;

public class SQLWhereClause {

	//Wichtig: Leerzeichen vor und nach dem Wert, da sonst der SQL-String nicht richtig aufgebaut werden kann.
	public enum Condition {
		AND(" AND "), OR(" OR "), NOTEQUAL(" != "), EQUAL(" = "), GREATER(" > "), LESS(" < "), GREATEREQUAL(" >= "), LESSEQUAL(" <= ");
		
		String representation;
		Condition( String representation ) {
			this.representation = representation;
		}
		public String toString() {
			return this.representation;
		}
	}
	
	private String leftOperand = null;
	private String rightOperand = null;
	private Condition comparison = null;
	private Condition connective = null;
	
	public SQLWhereClause(String leftOperand, String rightOperand, Condition comparison, Condition connective ) {
		this.leftOperand = leftOperand;
		this.rightOperand = rightOperand;
		this.comparison = comparison;
		this.connective = connective;
	}
	
	public String getLeftOperand() {
		return leftOperand;
	}
	public void setLeftOperand(String leftOperand) {
		this.leftOperand = leftOperand;
	}
	public String getRightOperand() {
		return rightOperand;
	}
	public void setRightOperand(String rightOperand) {
		this.rightOperand = rightOperand;
	}
	public Condition getComparison() {
		return comparison;
	}
	public void setComparison(Condition comparison) {
		this.comparison = comparison;
	}
	public Condition getConnective() {
		return connective;
	}
	public void setConnective(Condition connective) {
		this.connective = connective;
	}
	
	public String toString() {
		return this.leftOperand + this.connective + this.rightOperand;
	}
	
}
