package server.database.schema.maintenance;

import exception.DatabaseException;
import server.database.schema.SchemaColumn;
import server.database.schema.TableSchema;

/**
 * Tabellen-Schema fuer den flexiblen statischen SignatureCensor.
 * 
 * Achtung: Fuer eine korrekte Funktionsweise des SignatureCensors muss zusaetzlich zur 
 * Generierung des Schemas auch die sql-Datei 'staticSignatureCensorExperimentCreate.sql', 
 * die u.a. die Trigger fuer den SignatureCensor enthaelt, in der Datenbank ausgefuehrt 
 * werden.
 */
public class SignaturesFlexibleSignaturesPSchema extends TableSchema {

	public final static SchemaColumn SIG_ID = new SchemaColumn("SIG_ID", "NUMBER(7,0)", true, true);
	public final static SchemaColumn P_ID = new SchemaColumn("P_ID", "NUMBER(7,0)", true, true);
	public final static SchemaColumn FLAG_OLD = new SchemaColumn("FLAG_OLD", "NUMBER(1,0)", true);
	public final static SchemaColumn FLAG_IMPL = new SchemaColumn("FLAG_IMPL", "NUMBER(1,0)", true);
	
	public SignaturesFlexibleSignaturesPSchema() throws DatabaseException {
		super("SIGS_FLEX_SIGNATURES_P", SIG_ID, P_ID, FLAG_OLD, FLAG_IMPL);
	}
}
