package server.database.schema.maintenance;

import exception.DatabaseException;
import server.database.schema.SchemaColumn;
import server.database.schema.TableSchema;

public class ConfidentialityPolicyTableSchema extends TableSchema {

	public final static SchemaColumn ID = new SchemaColumn("ID", "NUMBER(7,0)", true, true, true);
	public final static SchemaColumn FORMULA = new SchemaColumn("FORMULA", "VARCHAR2(400 BYTE)", true);
	public final static SchemaColumn POLICY_TYPE = new SchemaColumn("POLICY_TYPE", "VARCHAR2(20 BYTE)", true, false, false, false, null, "'potential_secrets'", "epistemic", "secrecies", "potential_secrets");
	public final static SchemaColumn PRESERVATION = new SchemaColumn("PRESERVATION", "VARCHAR2(20 BYTE)", true, false, false, false, null, "'continuous'", "continuous", "temporary");
	public final static SchemaColumn USER_ID = new SchemaColumn("USER_ID", "NUMBER(7,0)", true, UserTableSchema.ID);
	
	public ConfidentialityPolicyTableSchema() throws DatabaseException {
		super("CONFPOLICY", ID, FORMULA, POLICY_TYPE, PRESERVATION, USER_ID);
	}
}
