package server.database.schema.app;

import exception.DatabaseException;
import server.data.Role;
import server.data.User;
import server.database.NewMaintenanceDatabase;
import server.database.schema.app.dict.GermanKrankheitDictionary2;
import server.database.schema.app.dict.GermanNachnameDictionary2;
import server.database.schema.app.dict.GermanSymptomDictionary;
import server.database.schema.maintenance.MaintenanceDatabaseSchema;


public class OpencensorsTestExample extends MaintenanceDatabaseSchema {

	public final KrankheitTableSchema krankheit;
	
	public final GermanSymptomDictionary symptomDict;
	public final GermanKrankheitDictionary2 diagnosisDict;
	public final GermanNachnameDictionary2 patientDict;
	
	
	public OpencensorsTestExample() throws DatabaseException {
		super("Opencensors Test Example");
		
		this.krankheit = new KrankheitTableSchema();
		
		// Add all tables to one list so that it can be iterated in the correct order easily.
		this.appTables.add( this.krankheit );
		
		this.symptomDict = new GermanSymptomDictionary();
		this.diagnosisDict = new GermanKrankheitDictionary2();
		this.patientDict = new GermanNachnameDictionary2();
		
		this.maintenanceTables.add( this.symptomDict );
		this.maintenanceTables.add( this.diagnosisDict );
		this.maintenanceTables.add( this.patientDict );
	}

	@Override
	public void fillMaintenanceDBWithContents(NewMaintenanceDatabase db) throws DatabaseException {
		super.createDefaultAccessRights(db);
		super.createAdminUser(db);
		
		String[] censors = {"OpenLying", "OpenCombined"};
		
		Role stdRole = Role.load(db.getDb(), 1);
		for( String censor : censors ) {
			User tmpUser = db.getUserManagement().add(censor.toLowerCase());
			tmpUser.setPassword(censor.toLowerCase());
			tmpUser.setCensor(censor);
			tmpUser.setRole(stdRole);
		}
		
		super.linkDictionary( db, this.symptomDict, KrankheitTableSchema.SYMPTOM );
		super.linkDictionary( db, this.diagnosisDict, KrankheitTableSchema.DIAGNOSIS );
		super.linkDictionary( db, this.patientDict, KrankheitTableSchema.PATIENT );
	}
}
