package server.database.schema.app;

import exception.DatabaseException;
import server.database.schema.SchemaColumn;
import server.database.schema.TableSchema;

public class NotenTableSchema extends TableSchema {
	
	public final static SchemaColumn MATRIKELNR = new SchemaColumn("MATRIKELNR", "VARCHAR2(400 BYTE)", true);
	public final static SchemaColumn VORLESUNG = new SchemaColumn("VORLESUNG", "VARCHAR2(400 BYTE)", true);
	public final static SchemaColumn NOTE = new SchemaColumn("NOTE", "VARCHAR2(400 BYTE)", true);
	
	public NotenTableSchema() throws DatabaseException {
		this("NOTEN");
	}
	
	public NotenTableSchema(String tablename) throws DatabaseException {
		super(tablename, MATRIKELNR, VORLESUNG, NOTE);
	}
}
