package server.core.notificationHandler;

import java.util.EnumSet;

import communication.CqeType;

import exception.LoadCensorException;
import notification.clientToServer.InteractionNotification;
import notification.serverToClient.ResultNotification;
import notification.serverToClient.StateNotification;
import server.censor.Censor;
import server.censor.QueryCensor;
import server.censor.UpdateCensor;
import server.core.Client;
import server.parser.Formula;

public class InteractionNotificationHandler extends NotificationHandler<InteractionNotification> {

	public InteractionNotificationHandler() {
		super(InteractionNotification.class, EnumSet.of(CqeType.Right.USER_LOGGED_IN));
	}

	@Override
	protected void handle(Client client, InteractionNotification notification) throws Exception {		
		logger.debug( "Received interaction: "+notification.getInteraction() );
		
		// Zeitmessung starten
		long startTime = System.currentTimeMillis();
		ResultNotification result = null;
		
		// Parse interaction.
		Formula formula = new Formula( notification.getInteraction() );
		
		// If no interaction type is set assume QUERY type.
		if ( formula.getInteractionType() == CqeType.InteractionType.NONE ) {
			formula.setInteractionType( CqeType.InteractionType.QUERY );
		}
		
		// TODO Let the automaton handle the rest.
		
		Censor censor = client.getServer().getCensorManagement().getCensor( client.getUser().getCensor() );
		
		if ( censor instanceof QueryCensor ) {
			result = ((QueryCensor)censor).evaluate(client, formula);
		} else if ( censor instanceof UpdateCensor ) {
			result = ((UpdateCensor)censor).update(client, formula);
		} else {
			throw new LoadCensorException("Censor is neither Query- nor Update-Censor. Unable to continue.", null);
		}
		
		long endTime = System.currentTimeMillis();
		result.setProcessingTime(endTime-startTime);
		
		client.send( result );
		client.send( new StateNotification("CURRENTLY NOT WORKING DUE TO BACKEND CHANGES") );
	}

}
