package server.core.notificationHandler;

import java.io.IOException;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;

import communication.CqeType;

import exception.DatabaseException;

import server.core.Client;
import server.data.User;
import notification.clientToServer.GetAllUsersNotification;
import notification.serverToClient.AllUsersNotification;

public class GetAllUsersNotificationHandler extends NotificationHandler<GetAllUsersNotification> {

	public GetAllUsersNotificationHandler() {
		super(GetAllUsersNotification.class, EnumSet.of(CqeType.Right.MANAGE_USERS));
	}

	@Override
	protected void handle(Client client, GetAllUsersNotification notification) throws IOException, DatabaseException {		
		List<User> users = client.getMaintenanceDB().getUserManagement().loadAll();
		List<user.User> userList = new LinkedList<user.User>();
		for ( User user : users ) {
			user.Role role = new user.Role( user.getRole().getId(), user.getRole().getName() );
			role.addAll( user.getRole().getRights() );
			user.User userCopy = new user.User(user.getId(), user.getUsername(), role, user.getConfidentialityPolicy().getCopyAsList(), user.getLog().getCopyAsList(), "FIXME", client.getMaintenanceDB().getPriorAll().getCopyAsList(), client.getMaintenanceDB().getSchemaConstraints().getCopyAsList(), user.getPriorUser().getCopyAsList());
			userList.add( userCopy );
		}
		client.send( new AllUsersNotification(userList) );
	}

}
