package server.core.notificationHandler;

import java.io.IOException;
import java.util.EnumSet;

import communication.CqeType;
import exception.DatabaseException;
import exception.UnknownUserException;
import exception.UnsupportedFormulaException;

import server.core.Client;
import server.data.ConfidentialityPolicyEntry;
import server.data.IdAndFormulaEntry;
import server.data.LogEntry;
import server.data.User;
import user.IdAndFormula;
import notification.clientToServer.DeleteUserInformationNotification;
import notification.serverToClient.OkayNotification;

public class DeleteUserInformationNotificationHandler extends NotificationHandler<DeleteUserInformationNotification>{

	public DeleteUserInformationNotificationHandler() {
		super(DeleteUserInformationNotification.class, EnumSet.of(CqeType.Right.MANAGE_USERS));
	}

	@Override
	protected void handle(Client client, DeleteUserInformationNotification notification) throws IOException, DatabaseException, UnknownUserException, UnsupportedFormulaException {
		User user = client.getMaintenanceDB().getUserManagement().load(notification.getUserId());
		
		switch ( notification.getType() ) {
		case IdAndFormula.TYPE_CONF_POL:
			for ( ConfidentialityPolicyEntry entry : user.getConfidentialityPolicy() ) {
				if ( entry.getId() == notification.getFormulaId() ) {
					user.getConfidentialityPolicy().remove(entry);
					client.send( new OkayNotification() );
					break;
				}
			}
			break;
		case IdAndFormula.TYPE_LOG:
			for ( LogEntry entry : user.getLog() ) {
				if ( entry.getId() == notification.getFormulaId() ) {
					user.getLog().remove(entry);
					client.send( new OkayNotification() );
					break;
				}
			}
			break;
		case IdAndFormula.TYPE_PRIOR:
			for ( IdAndFormulaEntry entry : user.getPriorUser() ) {
				if ( entry.getId() == notification.getFormulaId() ) {
					user.getPriorUser().remove(entry);
					client.send( new OkayNotification() );
					break;
				}
			}
			break;
		default:
			// FIXME exception type doesn't fit very well
			throw new UnsupportedFormulaException( null );
		}
		client.send( new OkayNotification(Boolean.FALSE) );
		
	}

}
