package server.censor.signature.util;

public abstract class TemplateDependencyElement {
	
	protected String value;
	
	public TemplateDependencyElement(String value) {
		this.value = value;
	}
	
	public boolean isConstant() {
		return false;
	}
	
	public boolean isSymbol() {
		return false;
	}
	
	public boolean isDistinguishedSymbol() {
		return false;
	}
	
	public boolean isNonDistinguishedSymbol() {
		return false;
	}
	
	public String getValue() {
		return this.value;
	}
	
	public void setValue(String value) {
		this.value = value;
	}
	
	public abstract TemplateDependencyElement copy();
	
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((value == null) ? 0 : value.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (!(obj instanceof TemplateDependencyElement))
			return false;
		TemplateDependencyElement other = (TemplateDependencyElement) obj;
		if (value == null) {
			if (other.value != null)
				return false;
		} else if (!value.equals(other.value))
			return false;
		return true;
	}
}
