package server.censor.signature;

import java.util.ArrayList;

import server.core.Client;
import server.core.Server;
import server.parser.Formula;
import exception.DatabaseException;
import exception.UnsupportedFormulaException;

/**
 * Klasse für den Zensor, der die flexible statische signaturbasierte Zugriffskontrolle realisiert.
 */
public class FlexibleStaticSignatureCensor extends StaticSignatureCensor {

	public FlexibleStaticSignatureCensor(Server server) throws DatabaseException {
		super("FlexibleStaticSignature", server);
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	protected String writeToCQEQuery( Client client, ArrayList<String> CQE_Query, Formula interaction, String[] ColumnNames, String relationname ) throws DatabaseException, UnsupportedFormulaException {
		return this.maintenanceUtil.writeToCQEQueryFlexible(client.getMaintenanceDB().getDb(), CQE_Query, interaction, ColumnNames, relationname, client.getUser().getId());
	}
}
