package server.censor.precqe;

import java.util.List;
import java.util.Vector;

import notification.serverToClient.UpdateResultNotification;
import server.censor.UpdateCensor;
import server.censor.refusal.RefusalUpdateCensor;
import server.core.Client;
import server.core.Server;
import server.data.LogEntry;
import server.parser.Formula;
import exception.DatabaseException;
import exception.ParserException;
import exception.UnsupportedFormulaException;
import user.IdAndFormula;

/**
 * Update für preCQE. Irgendwann mal drueber nachdenken und implementieren.
 *
 */
public class PreCQEUpdateCensor extends UpdateCensor {
	
	public PreCQEUpdateCensor(Server server) {
		super("PreCQEUpdate", server);
	}

	/**
	 * Update für die statische Inferenzkontrolle. Die alte Inferenzsichere Datenbank wird komplett 
	 * verworfen. Die Aenderungen werden in der Originaldatenbankinstanz gemacht und anschliessend
	 * eine neue inferenzsichere Datenbankinstanz fuer den Benutzer berechnet.
	 * Das Userlog muss bis auf das Vorwissen und die Datenbankconstraints komplett geloescht werden.
	 * 
	 * @param client
	 * @param literals
	 * @return
	 * @throws DatabaseException
	 * @throws UnsupportedFormulaException
	 * @throws ParserException 
	 */
	public UpdateResultNotification update(Client client, List<Formula> literals) throws DatabaseException, UnsupportedFormulaException, ParserException {
		// Entferne alle Eintraege aus Log.
		client.getUser().getLog().clear();
		
		// Fuehre die Datenbankaenderungen aus dem Update durch
		client.getApplicationDB().updateComplete( literals );		
		
		// Fuelle Log mit neuen Werten. Der Benutzer weiss nach dem Update, dass die hinzugefuegten Literale gelten
		Vector<IdAndFormula> addedToLog = new Vector<IdAndFormula>();
		String interaction = "VTR("+ RefusalUpdateCensor.listToString(literals)+")";	
		
		for ( Formula literal : literals ) {
			LogEntry entry = client.getUser().getLog().add(new Formula(interaction), null, literal, null);
			
			IdAndFormula logEntry = new IdAndFormula(entry.getId(), literal);
			addedToLog.add( logEntry );		
		}
		
		// Antwort ueber Erfolg der Aenderung geben
		return new UpdateResultNotification("transaction successful", literals.toString(), addedToLog);
	}

	@Override
	public UpdateResultNotification vup(Client client, Formula literal) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public UpdateResultNotification vtr(Client client, List<Formula> literals) throws Exception {
		return this.update(client, literals);
	}

	@Override
	public UpdateResultNotification pup(Client client, Formula literal) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public UpdateResultNotification ptr(Client client, List<Formula> literals) {
		// TODO Auto-generated method stub
		return null;
	}

}
