package notification.serverToClient;

import java.util.List;

import user.IdAndFormula;

/**
 * Diese Notification wird als Antwort auf eine Update-Interaktion
 * an den Client gesendet.
 */
public class UpdateResultNotification extends ResultNotification {
	private static final long serialVersionUID = -3027263620433058220L;
	
	private String result;
	
	/**
	 * Erstellt eine neue Ergebnisnachricht, die eine Zensorantwort, die Originalinteraktion und
	 * eine Liste mit Formeln die zum Log (View) hinzugefuegt werden enthaelt.
	 * 
	 * @param result Antwortnachricht des Zensors.
	 * @param interaction Originalanfrage des Benutzers.
	 * @param addToLog Informationen, die neu zum Log des Benutzers hinzugefuegt wurden.
	 */
	public UpdateResultNotification(String result, String interaction, List<IdAndFormula> addToLog) {
		super(interaction, addToLog);
		this.result = result;
	}
	
	/**
	 * Erstellt eine neue Ergebnisnachricht, die eine Zensorantwort, die Originalinteraktion und
	 * eine Liste mit Formeln die zum Log (View) hinzugefuegt werden enthaelt.
	 * 
	 * @param result Antwortnachricht des Zensors.
	 * @param interaction Originalanfrage des Benutzers.
	 * @param addToLog Informationen, die neu zum Log des Benutzers hinzugefuegt wurden.
	 * @param processingTime Bearbeitungszeit in Millisekunden
	 */
	public UpdateResultNotification(String result, String interaction, List<IdAndFormula> addToLog, long processingTime) {
		super(interaction, addToLog, processingTime);
		this.result = result;
	}
	
	/**
	 * Liefert die Antwortnachricht des Zensors zurueck. Enthaelt z.B. Ablehnungen
	 * oder eine Erfolgsmeldung.
	 * 
	 * @return Antwortnachricht des Zensors.
	 */
	public String getResult() {
		return this.result;
	}

}
