package notification.clientToServer;

import user.IdAndFormula;
import communication.CqeType;

import notification.Notification;

public class AddUserInformationNotification extends Notification {
	private static final long serialVersionUID = -6156750004537249970L;
	
	private int type;
	private int userId;
	private String formula;
	private CqeType.PolicyType policyType;
	private CqeType.PolicyPreservation preservation;

	public AddUserInformationNotification( int type, int userId, String formula ) {
		this.type = type;
		this.userId = userId;
		this.formula = formula;
		this.policyType = null;
		this.preservation = null;
	}
	
	public AddUserInformationNotification( int userId, String formula, CqeType.PolicyType policyType, CqeType.PolicyPreservation preservation ) {
		this.type = IdAndFormula.TYPE_CONF_POL;
		this.userId = userId;
		this.formula = formula;
		this.policyType = policyType;
		this.preservation = preservation;
	}

	public int getType() {
		return this.type;
	}

	public int getUserId() {
		return this.userId;
	}

	public String getFormula() {
		return this.formula;
	}
	
	public CqeType.PolicyType getPolicyType() {
		return this.policyType;
	}
	
	public CqeType.PolicyPreservation getPreservation() {
		return this.preservation;
	}
}
