package communication;

import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.Semaphore;


import notification.Notification;


/**
 * Verwendet eine LinkedList und Semaphore zur Kommunikationssteuerung.
 * @author Dirk Schalge
 *
 */
public class SemaphoreCommunication implements Communication {

	/**
	 * Queue, in der abrufbereite Nachrichten eingereit werden.
	 */
	private Queue<Notification> notifications;
	
	/**
	 * Semaphore, die nur Zugriff auf die Queue zulaesst, wenn Elemente enthalten sind.
	 */
	private Semaphore semaphore;

	/**
	 * Erzeugt einen neuen SemaphoreBuffer. Die Liste ist leer und recv() blockiert.
	 */
	public SemaphoreCommunication() {
		this.notifications = new LinkedList<Notification>();
		this.semaphore = new Semaphore( 0, true );
	}

	/**
	 * FIXME: FIFO und Zusammenhang zur Semaphore besser erlaeutern.
	 * Ruft eine Nachricht aus der Queue ab. Blockiert so lange, bis eine Nachricht vorliegt.
	 * @return Die abrufbereite Nachricht.
	 */
	public Notification recv() {
		try {
			this.semaphore.acquire();
		} catch ( Exception e ) {
			
		}
		//FIFO
		return this.notifications.poll();
	}

	/**
	 * Haengt eine Nachricht an die Queue an.
	 * @param notification Nachricht, die abrufbereit gemacht werden soll.
	 */
	public void send(Notification notification) {
		//FIFO
		this.notifications.offer( notification );
		
		//zaehlt 
		this.semaphore.release();
	}

	@Override
	public void disconnect() {
		this.notifications = null;
		this.semaphore = null;
	}
}
