package client.gui.usermanagement;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.List;

import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;

import client.core.Client;

import user.Role;
import user.User;

/**
 * GUI-Element: Zeigt eine Liste mit allen Benutzern und dessen Rollen. Bietet
 * die Möglichkeit einen neuen Benutzer mit Namen anzulegen oder einen markierten
 * Benutzer zu löschen.
 * @author schalge
 */
public class UserOverviewPanel extends JPanel implements ActionListener {
	private static final long serialVersionUID = 5771475479711769901L;
	
	private JTable userTable = null;
    private UserControlPanel userControlPanel = null;
    private UserModel userModel = null;

    /**
     * Erzeugt das beschriebene GUI-Element.
     */
    public UserOverviewPanel( List<User> users, List<Role> roles ) {
        this.setLayout( new BorderLayout() );
        //this.setBorder( BorderFactory.createMatteBorder(0, 0, 0, 5, Color.yellow) );

        this.userModel = new UserModel(users);
        this.userTable = new JTable( this.userModel );
        this.userTable.setSelectionMode( ListSelectionModel.SINGLE_SELECTION );
        this.userTable.setAutoCreateRowSorter( true );
        
        // ComboBox fuer Rollen
        JComboBox roleBox = new JComboBox( roles.toArray() );
        this.userTable.getColumnModel().getColumn(2).setCellEditor( new DefaultCellEditor(roleBox) );

        JScrollPane scrollpane = new JScrollPane( this.userTable );
        this.add( scrollpane, BorderLayout.CENTER );

        userControlPanel = new UserControlPanel();
        this.add( userControlPanel, BorderLayout.SOUTH );
        
        // Aktionen fuer Buttons abfangen
        this.userControlPanel.getAddButton().addActionListener( this );
        this.userControlPanel.getDeleteButton().addActionListener( this );
    }
    
    public UserModel getUserModel() {
    	return this.userModel;
    }
    
    public ListSelectionModel getSelectionModel() {
    	return this.userTable.getSelectionModel();
    }
    
    public User getSelectedUser() {
    	if ( this.getSelectionModel() == null || this.getUserModel() == null ) {
    		return null;
    	}
    	
    	int selectedIndex = this.getSelectionModel().getLeadSelectionIndex();
    	if ( selectedIndex < 0 || selectedIndex >= this.getUserModel().getRowCount() ) {
    		return null;
    	}
    	
		return this.getUserModel().getUser( selectedIndex );
    }

	@Override
	public void actionPerformed(ActionEvent event) {
		if ( event.getSource() == this.userControlPanel.getAddButton() ) {
			try {
				String newUsername = this.userControlPanel.getText();
				if( newUsername.equals("") ) {
					// no username specified
					JOptionPane.showMessageDialog(this, "Error! No username specified.", "Error", JOptionPane.ERROR_MESSAGE);
					return;
				}
				User user = Client.GUI.addUser( newUsername );
				if ( user != null ) {
					this.getUserModel().addUser(user);
				}
			} catch (IOException e) {
				e.printStackTrace();
			}
		} else if ( event.getSource() == this.userControlPanel.getDeleteButton() ) {
			int selectedIndex = this.getSelectionModel().getLeadSelectionIndex();
			User selectedUser = this.getSelectedUser();
			try {
				if ( Client.GUI.deleteUser(selectedUser.getUserId()) ) {
					this.getUserModel().deleteUser( selectedIndex );
				}
			} catch (IOException e) {
				e.printStackTrace();
			}
		} else {
			System.out.println("Unknown event source: "+event);
		}
		
	}
}
