package client.gui.usermanagement;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.util.List;

import javax.swing.JFrame;


import user.Role;
import user.User;

/**
 * GUI-Fenster: Zeigt ein Fenster mit der Benutzerverwaltung an.
 * @author schalge
 */
public class UserManagementFrame extends JFrame {
	private static final long serialVersionUID = 5786243631216604181L;
	
	private UserOverviewPanel userOverviewPanel;
	private UserDetailPanel userDetailPanel;

	/**
     * Erzeugt das beschriebene GUI-Element.
     */
    public UserManagementFrame( List<User> users, List<Role> roles ) {
        super();
        
        this.userOverviewPanel = new UserOverviewPanel(users, roles);
        this.userDetailPanel = new UserDetailPanel( this.userOverviewPanel );
        this.userOverviewPanel.getSelectionModel().setSelectionInterval(0, 0);

        // set window title
        this.setTitle( "CIE User Management" );

        // set minimum size
        this.setMinimumSize( new Dimension(1200,800) );
        this.setPreferredSize( new Dimension(1200,800) );

        // add main components
        this.setLayout( new BorderLayout() );
        this.add( this.userOverviewPanel, BorderLayout.WEST );
        this.add( this.userDetailPanel, BorderLayout.CENTER );

        // center on screen
        this.setLocationRelativeTo( this.getRootPane() );

        this.pack();
        this.setVisible(true);
    }
}
