package client.gui.usermanagement;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;

import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;

import notification.serverToClient.ExceptionNotification;


import client.core.Client;


import user.IdAndFormula;


/**
 * GUI-Element: Zeigt eine Liste mit Items an, die veraendert werden koennen.
 * @author schalge
 */
public class UserInformationListPanel extends JPanel implements ActionListener {
	private static final long serialVersionUID = 8867225601281388213L;
	
	private UserInformationModel<IdAndFormula> model = null;
	private JTable table = null;
	private UserManagementControlPanel controlPanel = null;
	private int identifier = -1;
	private UserOverviewPanel userOverviewPanel = null;


    /**
     * Erzeugt das beschriebene GUI-Element.
     */
    public UserInformationListPanel( String name, UserOverviewPanel userOverviewPanel ) {
    	this.userOverviewPanel = userOverviewPanel;
    	
    	// Determine identifier
    	if ( name.equalsIgnoreCase("log") ) {
    		this.identifier = IdAndFormula.TYPE_LOG;
    	} else if ( name.equalsIgnoreCase("prior") ) {
    		this.identifier = IdAndFormula.TYPE_PRIOR;
    	} else {
    		this.identifier = IdAndFormula.TYPE_CONF_POL;
    	}
    	
        this.setLayout( new BorderLayout() );
        this.setBorder( BorderFactory.createTitledBorder(name) );

        // initially select the first user
        int initialSelectedUser = this.userOverviewPanel.getUserModel().getUsers().get(0).getUserId();
        this.model = new UserInformationModel<IdAndFormula>( this.identifier, initialSelectedUser );
        this.table = new JTable( this.model );
        this.table.setShowGrid( false );
        this.table.setSelectionMode( ListSelectionModel.SINGLE_SELECTION );
        this.table.setTableHeader( null );
        JScrollPane scrollpane = new JScrollPane( this.table );
        scrollpane.setColumnHeader( null );
        this.add( scrollpane, BorderLayout.CENTER );

        this.controlPanel = new UserManagementControlPanel();
        this.controlPanel.getNewButton().addActionListener( this );
        this.controlPanel.getDelButton().addActionListener( this );
        this.add( this.controlPanel, BorderLayout.SOUTH );
    }
    
    public UserInformationModel<IdAndFormula> getModel() {
    	return this.model;
    }

	@Override
	public void actionPerformed(ActionEvent e) {
		if ( e.getActionCommand().equals("New Item") )	{
			String inputValue = JOptionPane.showInputDialog(userOverviewPanel, "Please input a valid formula", "Create new user knowledge", JOptionPane.PLAIN_MESSAGE);
			if( inputValue == null ) {
				// Abbrechen-Button geklickt
				return;
			}
			try {
				IdAndFormula formula =  Client.GUI.addUserInformationEntry( this.identifier, this.userOverviewPanel.getSelectedUser().getUserId(), inputValue );
				if ( formula != null ) {
					this.getModel().addFormula(formula);
				}
			} catch (IOException e1) {
				Client.GUI.showError("Unable to add entry.", e1, ExceptionNotification.NONCRITICAL);
			}
		} else if ( e.getActionCommand().equals("Delete Item") ) {
			if( this.table.getRowCount() == 0 ) {
				// kein Element zum Loeschen vorhanden
				return;
			}
			int selectedIndex = this.table.getSelectionModel().getLeadSelectionIndex();
			IdAndFormula formula = this.model.getFormula(selectedIndex);
			try {
				if ( Client.GUI.deleteUserInformationEntry(this.identifier, formula.getId(), this.userOverviewPanel.getSelectedUser().getUserId()) ) {
					this.getModel().deleteFormula( selectedIndex );
				}
			} catch (IOException e1) {
				Client.GUI.showError("Unable to delete entry.", e1, ExceptionNotification.NONCRITICAL);
			}
		}
	}

}
