package client.gui.usermanagement;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.swing.table.AbstractTableModel;

import notification.serverToClient.ExceptionNotification;

import communication.CqeType.PolicyPreservation;
import communication.CqeType.PolicyType;

import client.core.Client;
import exception.ParserException;

import server.parser.Formula;
import user.ConfidentialityPolicyItem;

public class ConfidentialityPolicyModel extends AbstractTableModel {
	private static final long serialVersionUID = 1984365020993292519L;
	
	private List<ConfidentialityPolicyItem> confPolItems = null;
	private int userId;
	
	public ConfidentialityPolicyModel(int userId) {
		this.confPolItems = new ArrayList<ConfidentialityPolicyItem>();
		this.userId = userId;
	}

	@Override
	public int getColumnCount() {
		return 3;
	}

	@Override
	public int getRowCount() {
		return this.confPolItems.size();
	}

	@Override
	public Object getValueAt(int rowIndex, int columnIndex) {
		if ( columnIndex == 0 ) {
			return this.confPolItems.get(rowIndex).getFormula();
		} else if ( columnIndex == 1 ) {
			return this.confPolItems.get(rowIndex).getType();
		} else {
			return this.confPolItems.get(rowIndex).getPreservation();
		}
	}
	
	@Override
	public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
		if ( columnIndex < 0 || columnIndex > 2 || this.confPolItems == null ) {
			return;
		}
		
		try {
			ConfidentialityPolicyItem oldItem = this.getConfidentialityPolicyItem( rowIndex );
			ConfidentialityPolicyItem newItem = new ConfidentialityPolicyItem(oldItem.getId(), oldItem.getFormula(), oldItem.getType(), oldItem.getPreservation());
			
			switch( columnIndex ) {
			case 0:
				// formula
				newItem.setFormula( new Formula((String)aValue) );
				break;
			case 1:
				// policy type
				newItem.setType( (PolicyType)aValue );
				break;
			case 2:
				// preservation type
				newItem.setPreservation( (PolicyPreservation)aValue );
				break;
			}
			
			if ( Client.GUI.editUserInformationConfidentialityPolicyEntry(userId, oldItem.getId(), newItem) ) {
				// Update erfolgreich, neue Werte uebernehmen (der Einfachheit halber alle, obwohl sich jeweils nur ein Wert geaendert haben kann)
				oldItem.setFormula( newItem.getFormula() );
				oldItem.setType( newItem.getType() );
				oldItem.setPreservation( newItem.getPreservation() );
			}
			else {
				Client.GUI.showError("Update failed.", null, ExceptionNotification.NONCRITICAL);
			}
		} catch (IOException e) {
			Client.GUI.showError("Failed to edit user information.", e, ExceptionNotification.NONCRITICAL);
		} catch (ArrayIndexOutOfBoundsException e) {
			Client.GUI.showError("Unknown user information.", e, ExceptionNotification.NONCRITICAL);
		} catch (ParserException e) {
			Client.GUI.showError("Unable to parse formula. Shouldn't happen as the server should notice this in the first place.", e, ExceptionNotification.NONCRITICAL);
		}
	}

	@Override
    public String getColumnName(int column) {
        if ( column == 0 ) {
            return "Formula";
        } else if ( column == 1 ) {
        	return "Policy Type";
        } else {
            return "Preservation Type";
        }
    }
	
	@Override
	public boolean isCellEditable(int row, int col) {
    	return true;
    }
	
	public void setList( List<ConfidentialityPolicyItem> list ) {
		this.confPolItems = list;
		this.fireTableDataChanged();
	}
	
	public ConfidentialityPolicyItem getConfidentialityPolicyItem(int index) {
		return confPolItems.get(index);
	}
	
	public void deleteConfidentialityPolicyItem( int index ) {
		this.confPolItems.remove(index);
		this.fireTableRowsDeleted( index, index );
	}
	
	public void addConfidentialityPolicyItem( ConfidentialityPolicyItem conf_pol_item ) {
		this.confPolItems.add( conf_pol_item );
    	this.fireTableRowsInserted( getRowCount()-1, getRowCount()-1 );
	}
}
