package client.gui.mainwindow;

import java.awt.BorderLayout;

import javax.swing.JLabel;
import javax.swing.JPanel;

/**
 * GUI-Oberelement: Kann von einem konkreten Tab abgeleitet werden, um ein
 * "Lade"-Bild anzuzeigen, bis der Inhalt des Tabs vorliegt.
 */
public abstract class LoadingTabPanel extends JPanel {
	private static final long serialVersionUID = 6788960865700578580L;
	
	private JLabel wait = null;

    /**
     * Erzeugt das beschriebene GUI-Element.
     */
    public LoadingTabPanel() {
        this.setLayout( new BorderLayout() );
        
        this.wait = new JLabel( "Executing interaction, please wait.." );
        this.wait.setHorizontalAlignment( JLabel.CENTER );
        this.wait.setVerticalAlignment( JLabel.CENTER );
        this.add( this.wait );
    }

    /**
     * Entfernt den aktuell angezeigten Ladebildschirm und zeigt den eigentlichen
     * Inhalt an.
     */
    public void showContent() {
        this.removeAll();
        this.wait = null;
        this.createContent();
        this.validate();
        this.repaint();
    }

    /**
     * Erzeugt den Inhalt des Tabs.
     */
    protected abstract void createContent();
}
