package client.gui.mainwindow;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.List;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import user.IdAndFormula;

public class InteractionResultPanel extends LoadingTabPanel {
	private static final long serialVersionUID = -8221652359330057731L;
	
	private String result = null;
	private String interaction = null;
	private long processingTime = 0;
	private JTextArea resultArea = null;
	private JLabel interactionLabel = null;
	private JLabel processingTimeLabel = null;
	
	public void showResult( String interaction, String result, long processingTime ) {
		this.result = result;
		this.interaction = interaction;
		this.processingTime = processingTime;
		
		this.showContent();
	}
	
	public void showResult( String interaction, List<IdAndFormula> result, long processingTime ) {
		this.interaction = interaction;
		
		this.result = "";
		for ( IdAndFormula resultEntry : result ) {
			this.result += resultEntry.toString() + "\n";
		}
		
		this.processingTime = processingTime;
		
		this.showContent();
	}

	@Override
	protected void createContent() {
		// Vertikale Anordnung der Elemente
		this.setLayout( new BoxLayout(this, BoxLayout.Y_AXIS) );
		
		this.interactionLabel = new JLabel( " Interaction: "+ this.interaction );
		this.interactionLabel.setAlignmentX( Component.LEFT_ALIGNMENT );
		this.interactionLabel.setFont( new Font("Serif", Font.BOLD, 12) );
		
		this.processingTimeLabel = new JLabel( "Processing Time: " + String.valueOf(this.processingTime/1000) + "." + String.valueOf(this.processingTime%1000) + " seconds" );
		this.processingTimeLabel.setAlignmentX( Component.RIGHT_ALIGNMENT );
		this.processingTimeLabel.setFont( new Font("Serif", Font.BOLD, 12) );
		
		this.resultArea = new JTextArea( this.result );
		this.resultArea.setEditable( false );
		this.resultArea.setFont( new Font("Times New Roman", Font.PLAIN, 16) );
		JScrollPane pane = new JScrollPane( this.resultArea );
		
		JPanel interactionProcessingTimePanel = new JPanel();
		interactionProcessingTimePanel.setLayout( new BoxLayout(interactionProcessingTimePanel, BoxLayout.X_AXIS) );
		interactionProcessingTimePanel.add(interactionLabel);
		interactionProcessingTimePanel.add( Box.createHorizontalGlue() );
		interactionProcessingTimePanel.add(processingTimeLabel);
		this.add( Box.createRigidArea(new Dimension(0,5)) );
		this.add( interactionProcessingTimePanel );
		this.add( Box.createRigidArea(new Dimension(0,5)) );
		this.add( pane );
	}
}
