package client.gui.automatonmanagement;

import java.awt.BorderLayout;
import java.util.Vector;

import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class TransitionDetailPanel extends JPanel {
	private static final long serialVersionUID = -3677885278118177258L;
	
	private DomainDetailPanel leftDomain = null;
	private DomainDetailPanel rightDomain = null;
	private JComboBox languageComboBox = null;
	
	public TransitionDetailPanel() {
		super();
		
		this.setLayout( new BorderLayout() );
        this.setBorder( BorderFactory.createTitledBorder("Transition details") );
        
        this.leftDomain = new DomainDetailPanel();
        this.rightDomain = new DomainDetailPanel();
        // FIXME "echte" Sprachen aus der Datenbank nehmen
        Vector<String> languageTypes = new Vector<String>();
        languageTypes.add( "First-order logic" );
        languageTypes.add( "Only atoms" );
        
        this.languageComboBox = new JComboBox( languageTypes );
        
        this.add( new JScrollPane(this.leftDomain), BorderLayout.WEST );
        this.add( this.languageComboBox, BorderLayout.CENTER );
        this.add( new JScrollPane(this.rightDomain), BorderLayout.EAST );

        this.add( new TransitionDetailControlPanel(), BorderLayout.SOUTH );
	}

}
