/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.tools;

import com.rapidminer.SpringUtilities;
import com.rapidminer.gui.tools.dialogs.wizards.AbstractWizard;
import com.rapidminer.gui.tools.dialogs.wizards.WizardStep;
import com.rapidminer.htmltools.SfbCommunication;
import com.rapidminer.operator.tools.DatasetImportWizard;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SpringLayout;

public class LoginWizardStep
extends WizardStep {
    private JTextField username = new JTextField(35);
    private JPasswordField password = new JPasswordField(25);
    private JLabel user = new JLabel("Username");
    private JLabel pass = new JLabel("Password");
    private SpringLayout layout = new SpringLayout();
    private JPanel springpanel = new JPanel(this.layout);
    private DatasetImportWizard diw;
    private int width = 390;
    private int height = 200;

    public LoginWizardStep(DatasetImportWizard diw) {
        super("login");
        this.diw = diw;
        this.springpanel.add(this.user);
        this.user.setLabelFor(this.username);
        this.username.setFocusable(true);
        this.springpanel.add(this.username);
        this.springpanel.add(this.pass);
        this.pass.setLabelFor(this.password);
        this.springpanel.add(this.password);
        SpringUtilities.makeCompactGrid(this.springpanel, 2, 2, 5, 5, 10, 5);
        this.username.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (LoginWizardStep.this.username.getText().length() > 3 && LoginWizardStep.this.password.getPassword().length > 3) {
                    LoginWizardStep.this.fireStateChanged();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        this.password.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (LoginWizardStep.this.username.getText().length() > 3 && LoginWizardStep.this.password.getPassword().length > 3) {
                    LoginWizardStep.this.fireStateChanged();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
    }

    protected String getTitle() {
        return "Login";
    }

    protected String getInfoText() {
        return "Login to SFB876";
    }

    protected JComponent getComponent() {
        return this.springpanel;
    }

    protected boolean canProceed() {
        boolean proceed = this.username.getText().length() > 3 && this.password.getPassword().length > 3;
        return proceed;
    }

    protected boolean canGoBack() {
        return false;
    }

    public void fireStateChanged() {
        super.fireStateChanged();
    }

    protected boolean performEnteringAction(AbstractWizard.WizardStepDirection direction) {
        this.diw.setSize(this.width, this.height);
        this.diw.setPreferredSize(new Dimension(this.width, this.height));
        this.diw.setResizable(false);
        if (direction == AbstractWizard.WizardStepDirection.BACKWARD) {
            this.diw.setPassword("");
            this.password.setText("");
        }
        if (!this.diw.getAuthenticated() && this.username.getText().length() > 3) {
            JOptionPane.showMessageDialog(this.springpanel, "Something went wrong while authenticating", "Error", 0);
        }
        this.username.requestFocusInWindow();
        return super.performEnteringAction(direction);
    }

    protected boolean performLeavingAction(AbstractWizard.WizardStepDirection direction) {
        this.diw.setUsername(this.username.getText());
        this.diw.setPassword(String.valueOf(this.password.getPassword()));
        boolean authenticated = new SfbCommunication().doInfolayerActions(this.diw, 2);
        this.diw.setAuthenticated(authenticated);
        return super.performLeavingAction(direction);
    }
}

