/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.tools;

import com.rapidminer.SpringUtilities;
import com.rapidminer.gui.tools.dialogs.wizards.AbstractWizard;
import com.rapidminer.gui.tools.dialogs.wizards.WizardStep;
import com.rapidminer.htmltools.SfbCommunication;
import com.rapidminer.operator.tools.DatasetImportWizard;
import java.awt.SystemColor;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SpringLayout;

public class ConfirmChangesWizardStep
extends WizardStep {
    private JLabel name = new JLabel("Name:");
    private JLabel problemDescription = new JLabel("Problem description:");
    private JLabel accessRight = new JLabel("Access right:");
    private JLabel sfbPartProject = new JLabel("SFB part project:");
    private JLabel person = new JLabel("Contact:");
    private JLabel data = new JLabel("Data-File:");
    private JLabel aml = new JLabel("AML-File:");
    private JLabel nameValue = new JLabel();
    private JLabel accessRightValue = new JLabel();
    private JLabel sfbPartProjectValue = new JLabel();
    private JLabel personValue = new JLabel();
    private JLabel dataValue = new JLabel();
    private JLabel amlValue = new JLabel();
    private JTextArea problemDescriptionValue = new JTextArea(10, 1);
    private JPanel panel = new JPanel(new SpringLayout());
    private DatasetImportWizard diw;
    private int width = 600;
    private int height = 550;

    public ConfirmChangesWizardStep(DatasetImportWizard diw) {
        super("confirm");
        this.diw = diw;
        this.panel.add(this.name);
        this.name.setLabelFor(this.nameValue);
        this.panel.add(this.nameValue);
        this.panel.add(this.problemDescription);
        this.problemDescriptionValue.setLineWrap(true);
        this.problemDescriptionValue.setEditable(false);
        this.problemDescriptionValue.setBackground(SystemColor.menu);
        JScrollPane scrollPane = new JScrollPane(this.problemDescriptionValue, 20, 31);
        this.problemDescription.setLabelFor(scrollPane);
        this.panel.add(scrollPane);
        this.panel.add(this.accessRight);
        this.accessRight.setLabelFor(this.accessRightValue);
        this.panel.add(this.accessRightValue);
        this.panel.add(this.sfbPartProject);
        this.sfbPartProject.setLabelFor(this.sfbPartProjectValue);
        this.panel.add(this.sfbPartProjectValue);
        this.panel.add(this.person);
        this.person.setLabelFor(this.personValue);
        this.panel.add(this.personValue);
        this.panel.add(this.data);
        this.data.setLabelFor(this.dataValue);
        this.panel.add(this.dataValue);
        this.panel.add(this.aml);
        this.aml.setLabelFor(this.amlValue);
        this.panel.add(this.amlValue);
        SpringUtilities.makeCompactGrid(this.panel, 7, 2, 5, 5, 10, 15);
    }

    protected String getTitle() {
        return "Confirm the input";
    }

    protected String getInfoText() {
        return "Confirm the submitted input before uploading the dataset";
    }

    protected JComponent getComponent() {
        return this.panel;
    }

    protected boolean canProceed() {
        return !this.diw.getDatasetName().equals("");
    }

    protected boolean canGoBack() {
        return true;
    }

    public void fireStateChanged() {
        super.fireStateChanged();
    }

    protected boolean performEnteringAction(AbstractWizard.WizardStepDirection direction) {
        this.nameValue.setText(this.diw.getDatasetName());
        this.problemDescriptionValue.setText(this.diw.getProblemDescription());
        this.accessRightValue.setText(this.diw.getAccessRights().get(this.diw.getChosenAccessRichts())[1]);
        this.sfbPartProjectValue.setText(this.diw.getSfbPartProjects().get(this.diw.getChosenSfbPartProjects())[1]);
        this.personValue.setText(this.diw.getPersons().get(this.diw.getChosenPersons())[1] + this.diw.getPersons().get(this.diw.getChosenPersons())[2]);
        String dataText = this.diw.getDataFile().getAbsolutePath();
        dataText = dataText.substring(dataText.lastIndexOf("/") + 1);
        this.dataValue.setText(dataText);
        dataText = this.diw.getAmlFile().getAbsolutePath();
        dataText = dataText.substring(dataText.lastIndexOf("/") + 1);
        this.amlValue.setText(dataText);
        this.diw.setSize(this.width, this.height);
        this.diw.setResizable(false);
        return super.performEnteringAction(direction);
    }

    protected boolean performLeavingAction(AbstractWizard.WizardStepDirection direction) {
        if (AbstractWizard.WizardStepDirection.FINISH == direction) {
            final SfbCommunication sma = new SfbCommunication();
            final DatasetImportWizard d = this.diw;
            new Thread(){

                @Override
                public void run() {
                    boolean set = sma.doInfolayerActions(ConfirmChangesWizardStep.this.diw, 3);
                    d.setDone(set);
                }
            }.start();
        }
        return super.performLeavingAction(direction);
    }
}

