/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.datasettools;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.io.process.XMLTools;
import com.rapidminer.tools.Ontology;
import com.rapidminer.tools.XMLException;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Dataset {
    public static final String EXAMPLESCOUNT = "examplescount";
    private ExampleSet exampleSet;

    public Dataset(ExampleSet exampleSet) {
        this.exampleSet = exampleSet;
    }

    public String prepareAmlFile(String path) {
        this.exampleSet.recalculateAllAttributeStatistics();
        String xmlString = "";
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = document.createElement("attributeset");
            root.setAttribute(EXAMPLESCOUNT, String.valueOf(this.exampleSet.size()));
            root.setAttribute("attributescount", String.valueOf(this.exampleSet.getAttributes().allSize()));
            root.setAttribute("default_source", path);
            document.appendChild(root);
            Iterator i = this.exampleSet.getAttributes().specialAttributes();
            while (i.hasNext()) {
                root.appendChild(this.writeAttributeMetaData((AttributeRole)i.next(), document, false));
            }
            i = this.exampleSet.getAttributes().regularAttributes();
            while (i.hasNext()) {
                root.appendChild(this.writeAttributeMetaData((AttributeRole)i.next(), document, false));
            }
            xmlString = XMLTools.toString((Document)document);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (XMLException e) {
            e.printStackTrace();
        }
        return xmlString;
    }

    private Element writeAttributeMetaData(AttributeRole attributeRole, Document document, boolean sparse) {
        String tag = "attribute";
        if (attributeRole.isSpecial()) {
            tag = attributeRole.getSpecialName();
        }
        Attribute attribute = attributeRole.getAttribute();
        return this.writeAttributeMetaData(tag, attribute, attribute.getTableIndex(), document, sparse);
    }

    private Element writeAttributeMetaData(String tag, Attribute attribute, int sourcecol, Document document, boolean sparse) {
        Element attributeElement = document.createElement(tag);
        attributeElement.setAttribute("name", attribute.getName());
        if (!sparse || tag.equals("attribute")) {
            attributeElement.setAttribute("sourcecol", String.valueOf(sourcecol));
        }
        attributeElement.setAttribute("valuetype", Ontology.VALUE_TYPE_NAMES[attribute.getValueType()]);
        if (!Ontology.ATTRIBUTE_BLOCK_TYPE.isA(attribute.getBlockType(), 1)) {
            attributeElement.setAttribute("blocktype", Ontology.ATTRIBUTE_BLOCK_TYPE.mapIndex(attribute.getBlockType()));
        }
        attributeElement.setAttribute("missingvalues", String.valueOf(this.exampleSet.getStatistics(attribute, "unknown")));
        if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 1)) {
            for (String nominalValue : attribute.getMapping().getValues()) {
                Element valueElement = document.createElement("value");
                valueElement.setTextContent(nominalValue);
                valueElement.setAttribute("valuecount", String.valueOf(this.exampleSet.getStatistics(attribute, "count", nominalValue)));
                attributeElement.appendChild(valueElement);
            }
        }
        if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 3) || Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 4)) {
            double min = this.exampleSet.getStatistics(attribute, "minimum");
            attributeElement.setAttribute("minvalue", String.valueOf(min));
            double max = this.exampleSet.getStatistics(attribute, "maximum");
            attributeElement.setAttribute("maxvalue", String.valueOf(max));
            double average = this.exampleSet.getStatistics(attribute, "average");
            attributeElement.setAttribute("average", String.valueOf(average));
            double variance = this.exampleSet.getStatistics(attribute, "variance");
            attributeElement.setAttribute("variance", String.valueOf(variance));
        }
        return attributeElement;
    }

    public String prepareDataFile() {
        Iterator reader = this.exampleSet.iterator();
        StringBuffer datafile = new StringBuffer();
        while (reader.hasNext()) {
            datafile.append(((Example)reader.next()).toDenseString(-2, true));
        }
        return datafile.toString();
    }
}

