/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.tools;

import com.rapidminer.Process;
import com.rapidminer.gui.properties.celleditors.value.PropertyValueCellEditor;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.Value;
import com.rapidminer.operator.tools.ParameterTypeParameter;
import com.rapidminer.parameter.ParameterType;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTable;

public class OperatorParameterValueCellEditor
extends AbstractCellEditor
implements PropertyValueCellEditor {
    private static final long serialVersionUID = 2332956173516489926L;
    private JPanel panel = new JPanel();
    private JComboBox operatorCombo;
    private JComboBox typeCombo = new JComboBox<String>(new String[]{"value", "parameter"});
    private JComboBox valueCombo = new JComboBox();
    private transient Process process;
    private ParameterTypeParameter type;

    public OperatorParameterValueCellEditor(ParameterTypeParameter type) {
        this.type = type;
    }

    public void setOperator(Operator operator) {
        this.process = operator.getProcess();
        this.operatorCombo = this.createOperatorCombo();
        this.typeCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                OperatorParameterValueCellEditor.this.fillValueCombo();
                OperatorParameterValueCellEditor.this.fireEditingStopped();
            }
        });
        this.valueCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                OperatorParameterValueCellEditor.this.fireEditingStopped();
            }
        });
        this.fillValueCombo();
        this.panel.setLayout(new GridLayout(1, 3));
        this.panel.add(this.operatorCombo);
        this.panel.add(this.typeCombo);
        this.panel.add(this.valueCombo);
        this.type.setDefaultValue(this.getCellEditorValue());
    }

    private JComboBox createOperatorCombo() {
        Vector allOps = new Vector(this.process.getAllOperatorNames());
        Collections.sort(allOps);
        JComboBox combo = new JComboBox(allOps);
        combo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                OperatorParameterValueCellEditor.this.fillValueCombo();
                OperatorParameterValueCellEditor.this.fireEditingStopped();
            }
        });
        return combo;
    }

    private void fillValueCombo() {
        this.valueCombo.removeAllItems();
        Operator operator = this.process.getOperator((String)this.operatorCombo.getSelectedItem());
        if (operator != null) {
            switch (this.typeCombo.getSelectedIndex()) {
                case 0: {
                    Iterator iV = operator.getValues().iterator();
                    while (iV.hasNext()) {
                        this.valueCombo.addItem(((Value)iV.next()).getKey());
                    }
                    if (this.valueCombo.getItemCount() != 0) break;
                    this.valueCombo.addItem("no values");
                    break;
                }
                case 1: {
                    Iterator iP = operator.getParameters().getParameterTypes().iterator();
                    while (iP.hasNext()) {
                        this.valueCombo.addItem(((ParameterType)iP.next()).getKey());
                    }
                    if (this.valueCombo.getItemCount() != 0) break;
                    this.valueCombo.addItem("no params");
                }
            }
        }
        this.valueCombo.setSelectedIndex(-1);
    }

    @Override
    public Object getCellEditorValue() {
        ParameterTypeParameter.OperatorParameterSelection selection = new ParameterTypeParameter.OperatorParameterSelection((String)this.operatorCombo.getSelectedItem(), this.typeCombo.getSelectedIndex() == 0, (String)this.valueCombo.getSelectedItem());
        return ParameterTypeParameter.transformOperatorValueSelection2String(selection);
    }

    public void setValue(String valueName) {
        if (valueName != null) {
            ParameterTypeParameter.OperatorParameterSelection selection = ParameterTypeParameter.transformString2OperatorValueSelection(valueName);
            if (selection != null) {
                this.operatorCombo.setSelectedItem(selection.getOperator());
                this.typeCombo.setSelectedIndex(selection.isValue() ? 0 : 1);
                this.valueCombo.setSelectedItem(selection.isValue() ? selection.getValueName() : selection.getParameterName());
            } else {
                this.operatorCombo.setSelectedIndex(0);
                this.typeCombo.setSelectedIndex(0);
                this.valueCombo.setSelectedIndex(-1);
            }
        } else {
            this.operatorCombo.setSelectedIndex(0);
            this.typeCombo.setSelectedIndex(0);
            this.valueCombo.setSelectedIndex(-1);
        }
        this.fireEditingStopped();
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
        this.setValue((String)value);
        return this.panel;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    public boolean useEditorAsRenderer() {
        return true;
    }

    public boolean rendersLabel() {
        return false;
    }
}

