/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.tools;

import com.rapidminer.gui.properties.celleditors.value.PropertyValueCellEditor;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.tools.ParameterTypeParameterInternal;
import com.rapidminer.tools.ParameterService;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Collections;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTable;

public class OperatorInternalParameterValueCellEditor
extends AbstractCellEditor
implements PropertyValueCellEditor {
    private static final long serialVersionUID = 2332956173516489926L;
    private JPanel panel = new JPanel();
    private JComboBox parameterCombo;
    private ParameterTypeParameterInternal type;

    public OperatorInternalParameterValueCellEditor(ParameterTypeParameterInternal type) {
        this.type = type;
    }

    public void setOperator(Operator operator) {
        this.parameterCombo = this.createOperatorCombo();
        this.panel.setLayout(new GridLayout(1, 1));
        this.panel.add(this.parameterCombo);
        this.type.setDefaultValue(this.getCellEditorValue());
    }

    private JComboBox createOperatorCombo() {
        Vector parameterVector = new Vector(ParameterService.getDefinedParameterKeys());
        Collections.sort(parameterVector);
        JComboBox combo = new JComboBox(parameterVector);
        return combo;
    }

    @Override
    public Object getCellEditorValue() {
        ParameterTypeParameterInternal.OperatorParameterInternalSelection selection = new ParameterTypeParameterInternal.OperatorParameterInternalSelection((String)this.parameterCombo.getSelectedItem());
        return ParameterTypeParameterInternal.transformOperatorValueSelection2String(selection);
    }

    public void setValue(String valueName) {
        if (valueName != null) {
            ParameterTypeParameterInternal.OperatorParameterInternalSelection selection = new ParameterTypeParameterInternal.OperatorParameterInternalSelection(valueName);
            this.parameterCombo.setSelectedItem(selection.getParameterName());
        } else {
            this.parameterCombo.setSelectedIndex(0);
        }
        this.fireEditingStopped();
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
        this.setValue((String)value);
        return this.panel;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    public boolean useEditorAsRenderer() {
        return true;
    }

    public boolean rendersLabel() {
        return false;
    }
}

