package de.dwds.ddc.client;

import org.json.*;

/** class for a single token in the matched sentence part of a DDCHit object */
public class DDCHitToken extends DDCJsonArray {
	//-----------------------------------------------------------------
	// properties (all public, because private data is annoying)
	
	/** true iff this token matched a term of the query */
	public boolean     matched_;
	
	/** indexed attributes, in the order specified by DDCHit.indices_ */
	public String[]    attrs_;
	
	//-----------------------------------------------------------------
	// constructors etc		
	/** default constructor */
	DDCHitToken() {
		super();
		matched_ = false;
		attrs_   = null;
	}

	/** constructor from json string */
	DDCHitToken(String jsonStr) throws JSONException
	{ super(jsonStr); }

	/** constructor from json object */
	DDCHitToken(JSONArray jsonObj) throws JSONException
	{ super(jsonObj); }

	// -----------------------------------------------------------------
	// parsing

	/** populate object by parsing ddc-2.x json data object */
	public void fromJson(JSONArray jsonObj) throws JSONException
	{
		super.fromJson(jsonObj);
		
		//-- parse: matched_
		matched_ = (obj.optInt(0,0) != 0);
		
		//-- parse: attrs_ 
		attrs_ = new String[obj.length()-1];
		for (int i=0; i <  attrs_.length; i++) {
			attrs_[i] = obj.optString(i+1);
		}
	}

	// -----------------------------------------------------------------
	// utilities
	
	/** wrapper for matched_ */
	public boolean isMatch()
	{ return matched_; }
	
	/** get default (text) attribute-value; wrapper for attrs_[0] */
	public String getText()
	{ return attrs_[0]; }

	/** get attribute-value by position; wrapper for attrs_[i] */
	public String getAttribute(int i)
	{ return attrs_[i]; }
	
}
