/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.mrmr;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorException;
import java.util.Iterator;

public class MRMRFunctions {
    public static final double LOG2INV = 1.0 / Math.log(2.0);

    public static double Correlation(ExampleSet exampleset, Attribute x, Attribute y) {
        double n = exampleset.size();
        if (n <= 0.0) {
            return 0.0;
        }
        double E_X = 0.0;
        double E_XX = 0.0;
        double E_Y = 0.0;
        double E_YY = 0.0;
        double E_XY = 0.0;
        for (Example example : exampleset) {
            double xi = example.getValue(x);
            double yi = example.getValue(y);
            E_X += xi;
            E_XX += xi * xi;
            E_Y += yi;
            E_YY += yi * yi;
            E_XY += xi * yi;
        }
        double zaehler = E_XY - E_X * E_Y / n;
        double nenner = Math.sqrt(Math.abs((E_XX - E_X * E_X / n) * (E_YY - E_Y * E_Y / n)));
        if (nenner == 0.0) {
            if (zaehler == 0.0) {
                return 0.0;
            }
            return Double.POSITIVE_INFINITY;
        }
        return zaehler / nenner;
    }

    public static double Correlation(ExampleSet exampleset, Attribute x, Attribute y, int ensembleSize) {
        double result = 0.0;
        double N = exampleset.size();
        if (N <= 0.0 || ensembleSize < 1) {
            return 0.0;
        }
        double EX = 0.0;
        double EXX = 0.0;
        double EY = 0.0;
        double EYY = 0.0;
        double EXY = 0.0;
        double[] n = new double[ensembleSize];
        double[] ex = new double[ensembleSize];
        double[] exx = new double[ensembleSize];
        double[] ey = new double[ensembleSize];
        double[] eyy = new double[ensembleSize];
        double[] exy = new double[ensembleSize];
        Iterator iterator = exampleset.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Example example = (Example)iterator.next();
            double xi = example.getValue(x);
            double yi = example.getValue(y);
            EX += xi;
            EXX += xi * xi;
            EY += yi;
            EYY += yi * yi;
            EXY += xi * yi;
            int n2 = i;
            ex[n2] = ex[n2] + xi;
            int n3 = i;
            exx[n3] = exx[n3] + xi * xi;
            int n4 = i;
            ey[n4] = ey[n4] + yi;
            int n5 = i;
            eyy[n5] = eyy[n5] + yi * yi;
            int n6 = i;
            exy[n6] = exy[n6] + xi * yi;
            int n7 = i++;
            n[n7] = n[n7] + 1.0;
            i %= ensembleSize;
        }
        for (i = 0; i < ensembleSize; ++i) {
            double zaehler = EXY - exy[i] - (EX - ex[i]) * (EY - ey[i]) / (N - n[i]);
            double nenner = Math.sqrt(Math.abs((EXX - exx[i] - (EX - ex[i]) * (EX - ex[i]) / (N - n[i])) * (EYY - eyy[i] - (EY - ey[i]) * (EY - ey[i]) / (N - n[i]))));
            if (nenner != 0.0) {
                result += zaehler / nenner;
                continue;
            }
            if (zaehler != 0.0) {
                result += Double.POSITIVE_INFINITY;
                continue;
            }
            result += 0.0;
        }
        return result / (double)ensembleSize;
    }

    public static double[] CorrelationEnsemble(ExampleSet exampleset, Attribute x, Attribute y, int ensembleSize) {
        double[] result = new double[ensembleSize];
        double N = exampleset.size();
        if (N <= 0.0 || ensembleSize < 1) {
            return result;
        }
        double EX = 0.0;
        double EXX = 0.0;
        double EY = 0.0;
        double EYY = 0.0;
        double EXY = 0.0;
        double[] n = new double[ensembleSize];
        double[] ex = new double[ensembleSize];
        double[] exx = new double[ensembleSize];
        double[] ey = new double[ensembleSize];
        double[] eyy = new double[ensembleSize];
        double[] exy = new double[ensembleSize];
        Iterator iterator = exampleset.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Example example = (Example)iterator.next();
            double xi = example.getValue(x);
            double yi = example.getValue(y);
            EX += xi;
            EXX += xi * xi;
            EY += yi;
            EYY += yi * yi;
            EXY += xi * yi;
            int n2 = i;
            ex[n2] = ex[n2] + xi;
            int n3 = i;
            exx[n3] = exx[n3] + xi * xi;
            int n4 = i;
            ey[n4] = ey[n4] + yi;
            int n5 = i;
            eyy[n5] = eyy[n5] + yi * yi;
            int n6 = i;
            exy[n6] = exy[n6] + xi * yi;
            int n7 = i++;
            n[n7] = n[n7] + 1.0;
            i %= ensembleSize;
        }
        for (i = 0; i < ensembleSize; ++i) {
            double zaehler = EXY - exy[i] - (EX - ex[i]) * (EY - ey[i]) / (N - n[i]);
            double nenner = Math.sqrt(Math.abs((EXX - exx[i] - (EX - ex[i]) * (EX - ex[i]) / (N - n[i])) * (EYY - eyy[i] - (EY - ey[i]) * (EY - ey[i]) / (N - n[i]))));
            result[i] = nenner != 0.0 ? zaehler / nenner : (zaehler != 0.0 ? Double.POSITIVE_INFINITY : 0.0);
        }
        return result;
    }

    public static double MutualInformation(ExampleSet exampleset, Attribute x, Attribute y) throws OperatorException {
        double result = 0.0;
        int n = exampleset.size();
        if (n == 0) {
            return 0.0;
        }
        if (!x.isNominal() || !y.isNominal()) {
            throw new OperatorException("Both attributes have to be nominal.");
        }
        int num_x = x.getMapping().size();
        int num_y = y.getMapping().size();
        double[] px = new double[num_x];
        double[] py = new double[num_y];
        double[][] pxy = new double[num_x][num_y];
        for (Example example : exampleset) {
            int xi = (int)example.getValue(x);
            int yi = (int)example.getValue(y);
            int n2 = xi;
            px[n2] = px[n2] + 1.0;
            int n3 = yi;
            py[n3] = py[n3] + 1.0;
            double[] dArray = pxy[xi];
            int n4 = yi;
            dArray[n4] = dArray[n4] + 1.0;
        }
        for (int i = 0; i < num_x; ++i) {
            for (int j = 0; j < num_y; ++j) {
                double temp = (double)n * pxy[i][j] / (px[i] * py[j]);
                if (!(temp > 0.0) || Double.isInfinite(temp)) continue;
                result += pxy[i][j] * Math.log(temp);
            }
        }
        if ((result *= LOG2INV) < 0.0) {
            return result / (double)n;
        }
        return result / (double)n;
    }

    public static double MutualInformation(ExampleSet exampleset, Attribute x, Attribute y, int ensembleSize) throws OperatorException {
        double result = 0.0;
        int N = exampleset.size();
        if (N == 0) {
            return 0.0;
        }
        if (!x.isNominal() || !y.isNominal()) {
            throw new OperatorException("Both attributes have to be nominal");
        }
        int num_x = x.getMapping().size();
        int num_y = y.getMapping().size();
        double[] PX = new double[num_x];
        double[] PY = new double[num_y];
        double[][] PXY = new double[num_x][num_y];
        double[][] px = new double[num_x][ensembleSize];
        double[][] py = new double[num_y][ensembleSize];
        double[][][] pxy = new double[num_x][num_y][ensembleSize];
        double[] n = new double[ensembleSize];
        Iterator iterator = exampleset.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Example example = (Example)iterator.next();
            int xi = (int)example.getValue(x);
            int yi = (int)example.getValue(y);
            int n2 = xi;
            PX[n2] = PX[n2] + 1.0;
            int n3 = yi;
            PY[n3] = PY[n3] + 1.0;
            double[] dArray = PXY[xi];
            int n4 = yi;
            dArray[n4] = dArray[n4] + 1.0;
            double[] dArray2 = px[xi];
            int n5 = i;
            dArray2[n5] = dArray2[n5] + 1.0;
            double[] dArray3 = py[yi];
            int n6 = i;
            dArray3[n6] = dArray3[n6] + 1.0;
            double[] dArray4 = pxy[xi][yi];
            int n7 = i;
            dArray4[n7] = dArray4[n7] + 1.0;
            int n8 = i++;
            n[n8] = n[n8] + 1.0;
            i %= ensembleSize;
        }
        for (i = 0; i < ensembleSize; ++i) {
            for (int k = 0; k < num_x; ++k) {
                for (int j = 0; j < num_y; ++j) {
                    double temp = ((double)N - n[i]) * (PXY[k][j] - pxy[k][j][i]) / ((PX[k] - px[k][i]) * (PY[j] - py[j][i]));
                    if (!(temp > 0.0) || Double.isInfinite(temp) || Double.isNaN(temp)) continue;
                    result += (PXY[k][j] - pxy[k][j][i]) * Math.log(temp) / ((double)N - n[i]);
                }
            }
        }
        return (result *= LOG2INV) / (double)ensembleSize;
    }

    public static double[] MutualInformationEnsemble(ExampleSet exampleset, Attribute x, Attribute y, int ensembleSize) throws OperatorException {
        double[] result = new double[ensembleSize];
        int N = exampleset.size();
        if (N == 0) {
            return result;
        }
        if (!x.isNominal() || !y.isNominal()) {
            throw new OperatorException("Both attributes have to be nominal");
        }
        int num_x = x.getMapping().size();
        int num_y = y.getMapping().size();
        double[] PX = new double[num_x];
        double[] PY = new double[num_y];
        double[][] PXY = new double[num_x][num_y];
        double[][] px = new double[num_x][ensembleSize];
        double[][] py = new double[num_y][ensembleSize];
        double[][][] pxy = new double[num_x][num_y][ensembleSize];
        double[] n = new double[ensembleSize];
        Iterator iterator = exampleset.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Example example = (Example)iterator.next();
            int xi = (int)example.getValue(x);
            int yi = (int)example.getValue(y);
            int n2 = xi;
            PX[n2] = PX[n2] + 1.0;
            int n3 = yi;
            PY[n3] = PY[n3] + 1.0;
            double[] dArray = PXY[xi];
            int n4 = yi;
            dArray[n4] = dArray[n4] + 1.0;
            double[] dArray2 = px[xi];
            int n5 = i;
            dArray2[n5] = dArray2[n5] + 1.0;
            double[] dArray3 = py[yi];
            int n6 = i;
            dArray3[n6] = dArray3[n6] + 1.0;
            double[] dArray4 = pxy[xi][yi];
            int n7 = i;
            dArray4[n7] = dArray4[n7] + 1.0;
            int n8 = i++;
            n[n8] = n[n8] + 1.0;
            i %= ensembleSize;
        }
        i = 0;
        while (i < ensembleSize) {
            result[i] = 0.0;
            for (int k = 0; k < num_x; ++k) {
                for (int j = 0; j < num_y; ++j) {
                    double temp = ((double)N - n[i]) * (PXY[k][j] - pxy[k][j][i]) / ((PX[k] - px[k][i]) * (PY[j] - py[j][i]));
                    if (!(temp > 0.0) || Double.isInfinite(temp) || Double.isNaN(temp)) continue;
                    int n9 = i;
                    result[n9] = result[n9] + (PXY[k][j] - pxy[k][j][i]) * Math.log(temp) / ((double)N - n[i]);
                }
            }
            int n10 = i++;
            result[n10] = result[n10] * LOG2INV;
        }
        return result;
    }

    public static double SymmetricalUncertainty(ExampleSet exampleset, Attribute x, Attribute y) throws OperatorException {
        int i;
        double result = 0.0;
        int n = exampleset.size();
        if (n == 0) {
            return 0.0;
        }
        if (!x.isNominal() || !y.isNominal()) {
            throw new OperatorException("Both attributes have to be nominal");
        }
        int num_x = x.getMapping().size();
        int num_y = y.getMapping().size();
        double[] px = new double[num_x];
        double[] py = new double[num_y];
        double[][] pxy = new double[num_x][];
        for (int l = 0; l < num_x; ++l) {
            pxy[l] = new double[num_y];
        }
        for (Example example : exampleset) {
            int xi = (int)example.getValue(x);
            int yi = (int)example.getValue(y);
            int n2 = xi;
            px[n2] = px[n2] + 1.0;
            int n3 = yi;
            py[n3] = py[n3] + 1.0;
            double[] dArray = pxy[xi];
            int n4 = yi;
            dArray[n4] = dArray[n4] + 1.0;
        }
        double Ixy = 0.0;
        double Hx = 0.0;
        double Hy = 0.0;
        for (i = 0; i < num_x; ++i) {
            for (int j = 0; j < num_y; ++j) {
                double temp = (double)n * pxy[i][j] / (px[i] * py[j]);
                if (!(temp > 0.0) || Double.isInfinite(temp)) continue;
                Ixy += pxy[i][j] * Math.log(temp);
            }
            if (!(px[i] > 0.0)) continue;
            Hx += px[i] * Math.log(px[i]);
        }
        for (i = 0; i < num_y; ++i) {
            if (!(py[i] > 0.0)) continue;
            Hy += py[i] * Math.log(py[i]);
        }
        if (Hx + Hy == 0.0) {
            return 0.0;
        }
        result = 2.0 * Ixy / ((double)n * (Hx + Hy));
        return result;
    }

    public static double FTest(ExampleSet exampleset, Attribute num_var, Attribute nom_var) {
        int N = exampleset.size();
        int K = nom_var.getMapping().getValues().size();
        if (N == 0 || K <= 1 || N <= K) {
            return 0.0;
        }
        double[] n = new double[K];
        double g = 0.0;
        double[] sum_x = new double[K];
        double[] sum_xx = new double[K];
        for (Example example : exampleset) {
            double x = example.getValue(num_var);
            int y = (int)example.getValue(nom_var);
            g += x;
            int n2 = y;
            n[n2] = n[n2] + 1.0;
            int n3 = y;
            sum_x[n3] = sum_x[n3] + x;
            int n4 = y;
            sum_xx[n4] = sum_xx[n4] + x * x;
        }
        g /= (double)N;
        double zaehler = 0.0;
        double nenner = 0.0;
        for (int k = 0; k < K; ++k) {
            if (!(n[k] > 0.0)) continue;
            zaehler += n[k] * Math.pow(sum_x[k] / n[k] - g, 2.0);
            nenner += sum_xx[k] - sum_x[k] * sum_x[k] / n[k];
        }
        zaehler *= (double)(N - K);
        if ((nenner *= (double)(K - 1)) == 0.0) {
            return 0.0;
        }
        return zaehler / nenner;
    }

    public static double FTest(ExampleSet exampleset, Attribute num_var, Attribute nom_var, int ensembleSize) {
        int N = exampleset.size();
        int K = nom_var.getMapping().getValues().size();
        if (N == 0 || K <= 1 || N <= K || ensembleSize < 1 || ensembleSize > N) {
            return 0.0;
        }
        double[][] n = new double[K][ensembleSize];
        double[] g = new double[ensembleSize];
        double[][] sum_x = new double[K][ensembleSize];
        double[][] sum_xx = new double[K][ensembleSize];
        double[] tot_n = new double[K];
        double tot_g = 0.0;
        double[] tot_sum_x = new double[K];
        double[] tot_sum_xx = new double[K];
        Iterator iterator = exampleset.iterator();
        int i = 0;
        double[] Ni = new double[ensembleSize];
        while (iterator.hasNext()) {
            Example example = (Example)iterator.next();
            double x = example.getValue(num_var);
            int y = (int)example.getValue(nom_var);
            tot_g += x;
            int n2 = y;
            tot_n[n2] = tot_n[n2] + 1.0;
            int n3 = y;
            tot_sum_x[n3] = tot_sum_x[n3] + x;
            int n4 = y;
            tot_sum_xx[n4] = tot_sum_xx[n4] + x * x;
            int n5 = i;
            g[n5] = g[n5] + x;
            double[] dArray = n[y];
            int n6 = i;
            dArray[n6] = dArray[n6] + 1.0;
            double[] dArray2 = sum_x[y];
            int n7 = i;
            dArray2[n7] = dArray2[n7] + x;
            double[] dArray3 = sum_xx[y];
            int n8 = i;
            dArray3[n8] = dArray3[n8] + x * x;
            int n9 = i++;
            Ni[n9] = Ni[n9] + 1.0;
            i %= ensembleSize;
        }
        double[] zaehler = new double[ensembleSize];
        double[] nenner = new double[ensembleSize];
        double avg = 0.0;
        double ens = 0.0;
        for (i = 0; i < ensembleSize; ++i) {
            for (int k = 0; k < K; ++k) {
                if (!(tot_n[k] - n[k][i] > 0.0)) continue;
                int n10 = i;
                zaehler[n10] = zaehler[n10] + (tot_n[k] - n[k][i]) * Math.pow((tot_sum_x[k] - sum_x[k][i]) / (tot_n[k] - n[k][i]) - (tot_g - g[i]) / ((double)N - Ni[i]), 2.0);
                int n11 = i;
                nenner[n11] = nenner[n11] + (tot_sum_xx[k] - sum_xx[k][i] - (tot_sum_x[k] - sum_x[k][i]) * (tot_sum_x[k] - sum_x[k][i]) / (tot_n[k] - n[k][i]));
            }
            int n12 = i;
            zaehler[n12] = zaehler[n12] * ((double)N - Ni[i] - (double)K);
            int n13 = i;
            nenner[n13] = nenner[n13] * (double)(K - 1);
            if (nenner[i] == 0.0 || Double.isNaN(nenner[i])) continue;
            avg += zaehler[i] / nenner[i];
            ens += 1.0;
        }
        if (ens == 0.0) {
            return 0.0;
        }
        return avg / ens;
    }

    public static double[] FTestEnsemble(ExampleSet exampleset, Attribute num_var, Attribute nom_var, int ensembleSize) {
        double[] result = new double[ensembleSize];
        int N = exampleset.size();
        int K = nom_var.getMapping().getValues().size();
        if (N == 0 || K <= 1 || N <= K || ensembleSize < 1 || ensembleSize > N) {
            return result;
        }
        double[][] n = new double[K][ensembleSize];
        double[] g = new double[ensembleSize];
        double[][] sum_x = new double[K][ensembleSize];
        double[][] sum_xx = new double[K][ensembleSize];
        double[] tot_n = new double[K];
        double tot_g = 0.0;
        double[] tot_sum_x = new double[K];
        double[] tot_sum_xx = new double[K];
        Iterator iterator = exampleset.iterator();
        int i = 0;
        double[] Ni = new double[ensembleSize];
        while (iterator.hasNext()) {
            Example example = (Example)iterator.next();
            double x = example.getValue(num_var);
            int y = (int)example.getValue(nom_var);
            tot_g += x;
            int n2 = y;
            tot_n[n2] = tot_n[n2] + 1.0;
            int n3 = y;
            tot_sum_x[n3] = tot_sum_x[n3] + x;
            int n4 = y;
            tot_sum_xx[n4] = tot_sum_xx[n4] + x * x;
            int n5 = i;
            g[n5] = g[n5] + x;
            double[] dArray = n[y];
            int n6 = i;
            dArray[n6] = dArray[n6] + 1.0;
            double[] dArray2 = sum_x[y];
            int n7 = i;
            dArray2[n7] = dArray2[n7] + x;
            double[] dArray3 = sum_xx[y];
            int n8 = i;
            dArray3[n8] = dArray3[n8] + x * x;
            int n9 = i++;
            Ni[n9] = Ni[n9] + 1.0;
            i %= ensembleSize;
        }
        double nenner = 0.0;
        double zaehler = 0.0;
        for (i = 0; i < ensembleSize; ++i) {
            nenner = 0.0;
            zaehler = 0.0;
            for (int k = 0; k < K; ++k) {
                if (!(tot_n[k] - n[k][i] > 0.0)) continue;
                zaehler += (tot_n[k] - n[k][i]) * Math.pow((tot_sum_x[k] - sum_x[k][i]) / (tot_n[k] - n[k][i]) - (tot_g - g[i]) / ((double)N - Ni[i]), 2.0);
                nenner += tot_sum_xx[k] - sum_xx[k][i] - (tot_sum_x[k] - sum_x[k][i]) * (tot_sum_x[k] - sum_x[k][i]) / (tot_n[k] - n[k][i]);
            }
            result[i] = (nenner *= (double)(K - 1)) != 0.0 && !Double.isNaN(nenner) ? (zaehler *= (double)N - Ni[i] - (double)K) / nenner : 0.0;
        }
        return result;
    }

    public static double WelchTest(ExampleSet exampleset, Attribute num_var, Attribute nom_var) {
        int N = exampleset.size();
        int K = nom_var.getMapping().getValues().size();
        if (K != 2) {
            return 0.0;
        }
        if (N == 0) {
            return 0.0;
        }
        double[] n = new double[K];
        double[] sum_x = new double[K];
        double[] sum_xx = new double[K];
        for (Example example : exampleset) {
            int y;
            double x = example.getValue(num_var);
            int n2 = y = (int)example.getValue(nom_var);
            n[n2] = n[n2] + 1.0;
            int n3 = y;
            sum_x[n3] = sum_x[n3] + x;
            int n4 = y;
            sum_xx[n4] = sum_xx[n4] + x * x;
        }
        double zaehler = 0.0;
        double nenner = 0.0;
        zaehler += Math.abs(sum_x[0] - sum_x[1]);
        try {
            nenner += (double)N * Math.sqrt((sum_xx[0] - sum_x[0] * sum_x[0] / n[0]) / (n[0] * (n[0] - 1.0)) + (sum_xx[1] - sum_x[1] * sum_x[1] / n[1]) / (n[1] * (n[1] - 1.0)));
        }
        catch (Exception e) {
            // empty catch block
        }
        if (nenner == 0.0) {
            return 0.0;
        }
        return zaehler / nenner;
    }

    public static double SAM_Statistics(ExampleSet exampleSet, Attribute attribute, double s0) throws OperatorException {
        int n = exampleSet.size();
        if (n <= 2) {
            throw new OperatorException("The example set needs at least 3 examples.");
        }
        int n1 = 0;
        int n2 = 0;
        double x1 = 0.0;
        double x2 = 0.0;
        double xx1 = 0.0;
        double xx2 = 0.0;
        double val = 0.0;
        for (Example example : exampleSet) {
            if (example.getLabel() == 0.0) {
                val = example.getValue(attribute);
                x1 += val;
                xx1 += val * val;
                ++n1;
                continue;
            }
            val = example.getValue(attribute);
            x2 += val;
            xx2 += val * val;
            ++n2;
        }
        double a = (1.0 / (double)n1 + 1.0 / (double)n2) / (double)(n1 + n2 - 2);
        return Math.abs(x1 / (double)n1 - x2 / (double)n2) / (Math.sqrt(a * (xx1 - x1 * x1 / (double)n1 + (xx2 - x2 * x2 / (double)n2))) + s0);
    }

    public static double GetSimilarity(ExampleSet exampleset, Attribute x, Attribute y) throws OperatorException {
        if (x.isNominal()) {
            if (y.isNominal()) {
                return MRMRFunctions.MutualInformation(exampleset, x, y);
            }
            return MRMRFunctions.FTest(exampleset, y, x);
        }
        if (y.isNominal()) {
            return MRMRFunctions.FTest(exampleset, x, y);
        }
        return MRMRFunctions.Correlation(exampleset, x, y);
    }

    public static double GetSimilarity(ExampleSet exampleset, Attribute x, Attribute y, int ensembleSize) throws OperatorException {
        if (x.isNominal()) {
            if (y.isNominal()) {
                return MRMRFunctions.MutualInformation(exampleset, x, y, ensembleSize);
            }
            return MRMRFunctions.FTest(exampleset, y, x, ensembleSize);
        }
        if (y.isNominal()) {
            return MRMRFunctions.FTest(exampleset, x, y, ensembleSize);
        }
        return MRMRFunctions.Correlation(exampleset, x, y, ensembleSize);
    }

    public static double[] GetSimilarityEnsemble(ExampleSet exampleset, Attribute x, Attribute y, int ensembleSize) throws OperatorException {
        if (x.isNominal()) {
            if (y.isNominal()) {
                return MRMRFunctions.MutualInformationEnsemble(exampleset, x, y, ensembleSize);
            }
            return MRMRFunctions.FTestEnsemble(exampleset, y, x, ensembleSize);
        }
        if (y.isNominal()) {
            return MRMRFunctions.FTestEnsemble(exampleset, x, y, ensembleSize);
        }
        return MRMRFunctions.CorrelationEnsemble(exampleset, x, y, ensembleSize);
    }
}

