/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.mrmr;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCapability;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.Value;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.features.weighting.AbstractWeighting;
import com.rapidminer.operator.mfs.Util;
import com.rapidminer.operator.mrmr.MRMRFunctions;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class MRMRFeatureSelection
extends AbstractWeighting {
    public static final String PARAMETER_METHOD = "relevance_redundancy_relation";
    public static final String[] METHODS = new String[]{"quotient", "difference"};
    public static final int METHOD_MIQ = 0;
    public static final int METHOD_MID = 1;
    public static final String PARAMETER_SETS_OR_RANKS = "sets_or_ranks";
    public static final String[] SETS_OR_RANKS = new String[]{"sets", "ranks"};
    public static final int SETS = 0;
    public static final int RANKS = 1;
    public static final String PARAMETER_FULL_RANKING = "calculate full ranking";
    public static final String PARAMETER_ENSEMBLES = "use_ensemble_method";
    public static final String[] ENSEMBLE_METHODS = new String[]{"none", "for_measures", "full_ensemble"};
    public static final int ENSEMBLE_NO = 0;
    public static final int ENSEMBLE_INNER = 1;
    public static final int ENSEMBLE_FULL = 2;
    public static final String PARAMETER_ENSEMBLE_SIZE = "ensemble_size";
    public static final String PARAMETER_MAXGEN = "max_generations";
    public static final String PARAMETER_K = "k";
    public static final String PARAMETER_LOCAL_RANDOM_SEED = "local_random_seed";
    public static final String PARAMETER_LOG = "logging";
    private boolean logging = false;
    private int iteration = 0;
    private double comparisons = 0.0;
    private double cachesize = 0.0;

    public MRMRFeatureSelection(OperatorDescription description) {
        super(description);
        this.addValue((Value)new ValueDouble("comparisons", "The number of needed comparisons."){

            public double getDoubleValue() {
                return MRMRFeatureSelection.this.comparisons;
            }
        });
        this.addValue((Value)new ValueDouble("cachesize", "The number of actually calculated comparisons"){

            public double getDoubleValue() {
                return MRMRFeatureSelection.this.cachesize;
            }
        });
        this.addValue((Value)new ValueDouble("iteration", "The number of the current iteration."){

            public double getDoubleValue() {
                return MRMRFeatureSelection.this.iteration;
            }
        });
    }

    protected AttributeWeights calculateWeights(ExampleSet exampleSet) throws OperatorException {
        this.comparisons = 0.0;
        this.cachesize = 0.0;
        if (exampleSet.getAttributes().getLabel() == null) {
            throw new UserError((Operator)this, 105);
        }
        this.logging = this.getParameterAsBoolean(PARAMETER_LOG);
        int k = this.getParameterAsInt(PARAMETER_K);
        int method = this.getParameterAsInt(PARAMETER_METHOD);
        AttributeWeights resWeights = null;
        resWeights = this.getParameterAsInt(PARAMETER_ENSEMBLES) == 2 ? this.doForwardEnsemble(exampleSet, k, method, this.getParameterAsInt(PARAMETER_ENSEMBLE_SIZE), this.getParameterAsInt(PARAMETER_SETS_OR_RANKS) == 1) : this.doForward(exampleSet, k, method);
        return resWeights;
    }

    protected AttributeWeights doForward(ExampleSet eset, int k, int method) throws OperatorException {
        Attribute att;
        AttributeWeights result = new AttributeWeights(eset);
        for (String name : result.getAttributeNames()) {
            result.setWeight(name, 0.0);
        }
        Attributes allAttributes = eset.getAttributes();
        Attribute best = null;
        double bestPerf = Double.NEGATIVE_INFINITY;
        double tmpPerf = 0.0;
        HashSet<Attribute> selection = new HashSet<Attribute>(k);
        HashMap<Integer, Double> relevance = new HashMap<Integer, Double>((int)((double)result.size() / 0.75) + 1);
        Attribute label = allAttributes.getLabel();
        Iterator it = allAttributes.regularAttributes();
        boolean useInnerEnsemble = this.getParameterAsInt(PARAMETER_ENSEMBLES) == 1;
        int ensembleSize = this.getParameterAsInt(PARAMETER_ENSEMBLE_SIZE);
        if (useInnerEnsemble) {
            while (it.hasNext()) {
                att = ((AttributeRole)it.next()).getAttribute();
                tmpPerf = Math.abs(MRMRFunctions.GetSimilarity(eset, att, label, ensembleSize));
                this.comparisons += 1.0;
                relevance.put(att.getTableIndex(), tmpPerf);
                if (!(tmpPerf > bestPerf)) continue;
                bestPerf = tmpPerf;
                best = att;
            }
        } else {
            while (it.hasNext()) {
                att = ((AttributeRole)it.next()).getAttribute();
                tmpPerf = Math.abs(MRMRFunctions.GetSimilarity(eset, att, label));
                this.comparisons += 1.0;
                relevance.put(att.getTableIndex(), tmpPerf);
                if (!(tmpPerf > bestPerf)) continue;
                bestPerf = tmpPerf;
                best = att;
            }
        }
        selection.add(best);
        result.setWeight(best.getName(), 1.0);
        if (this.logging) {
            this.log("Current performance: " + bestPerf + " , added: " + best.getName());
        }
        long already_cached = 0L;
        HashMap<Long, Double> cache = new HashMap<Long, Double>(k * allAttributes.size());
        Double c_temp = 0.0;
        long index1 = 0L;
        long index2 = 0L;
        long p = allAttributes.allSize();
        double redundancy = 0.0;
        for (int i = 1; i < k; ++i) {
            bestPerf = Double.NEGATIVE_INFINITY;
            it = allAttributes.regularAttributes();
            while (it.hasNext()) {
                att = ((AttributeRole)it.next()).getAttribute();
                index1 = att.getTableIndex();
                if (selection.contains(att)) continue;
                redundancy = 0.0;
                double counter = 0.0;
                for (Attribute selected : selection) {
                    index2 = selected.getTableIndex();
                    Long cacheId = index1 > index2 ? Long.valueOf(index1 + index2 * p) : Long.valueOf(index1 * p + index2);
                    if (cache.containsKey(cacheId)) {
                        redundancy += ((Double)cache.get(cacheId)).doubleValue();
                        ++already_cached;
                    } else {
                        c_temp = useInnerEnsemble ? Double.valueOf(MRMRFunctions.GetSimilarity(eset, selected, att, ensembleSize)) : Double.valueOf(MRMRFunctions.GetSimilarity(eset, selected, att));
                        if (c_temp < 0.0) {
                            c_temp = 0.0 - c_temp;
                        }
                        cache.put(cacheId, c_temp);
                        redundancy += c_temp.doubleValue();
                    }
                    counter += 1.0;
                }
                if (counter != 0.0) {
                    redundancy /= counter;
                }
                if (method == 0) {
                    tmpPerf = (Double)relevance.get(att.getTableIndex());
                    if (tmpPerf != 0.0) {
                        tmpPerf = redundancy != 0.0 ? (tmpPerf /= redundancy) : Double.POSITIVE_INFINITY;
                    }
                } else {
                    tmpPerf = (Double)relevance.get(att.getTableIndex()) - redundancy;
                }
                if (Double.isNaN(tmpPerf)) {
                    System.out.print("MRMR-FS: tmpPerf is NaN. Replaced by Double.NEGATIVE_INFINITY");
                    System.out.print("\n");
                    tmpPerf = Double.NEGATIVE_INFINITY;
                }
                if (!(tmpPerf > bestPerf)) continue;
                bestPerf = tmpPerf;
                best = att;
            }
            result.setWeight(best.getName(), 1.0);
            selection.add(best);
            if (!this.logging) continue;
            this.log("Current performance: " + bestPerf + " , added: " + best.getName());
        }
        this.cachesize = cache.size();
        this.comparisons += this.cachesize;
        if (this.logging) {
            this.log("Cached: " + already_cached + " \tnot cached (cache size): " + this.cachesize);
        }
        relevance.clear();
        selection.clear();
        cache.clear();
        return result;
    }

    protected AttributeWeights doForwardEnsemble(ExampleSet exampleset, int k, int method, int ensembleSize, boolean useRankings) throws OperatorException {
        AttributeWeights result;
        int e;
        Attribute att;
        int i;
        Attributes allAttributes = exampleset.getAttributes();
        Attribute label = allAttributes.getLabel();
        HashMap<Integer, double[]> relevance = new HashMap<Integer, double[]>((int)((double)allAttributes.size() / 0.75) + 1);
        int N = exampleset.size();
        if (N == 0) {
            return Util.CreateZeroWeights(exampleset);
        }
        Attribute[] best = new Attribute[ensembleSize];
        double[] bestPerf = new double[ensembleSize];
        HashSet[] selection = new HashSet[ensembleSize];
        ArrayList[] ranks = new ArrayList[ensembleSize];
        for (i = 0; i < ensembleSize; ++i) {
            best[i] = null;
            bestPerf[i] = Double.NEGATIVE_INFINITY;
            selection[i] = new HashSet(k);
            ranks[i] = new ArrayList(k);
        }
        Iterator it = allAttributes.regularAttributes();
        while (it.hasNext()) {
            att = ((AttributeRole)it.next()).getAttribute();
            double[] tmp_relevs = MRMRFunctions.GetSimilarityEnsemble(exampleset, att, label, ensembleSize);
            relevance.put(att.getTableIndex(), tmp_relevs);
            this.comparisons += 1.0;
            for (e = 0; e < ensembleSize; ++e) {
                if (!(Math.abs(tmp_relevs[e]) > bestPerf[e])) continue;
                bestPerf[e] = Math.abs(tmp_relevs[e]);
                best[e] = att;
            }
        }
        for (e = 0; e < ensembleSize; ++e) {
            selection[e].add(best[e]);
            ranks[e].add(best[e]);
            bestPerf[e] = Double.NEGATIVE_INFINITY;
        }
        HashMap<Long, double[]> cache = new HashMap<Long, double[]>(k * allAttributes.size());
        double tmpPerf = 0.0;
        double counter = 0.0;
        double redundancy = 0.0;
        long already_cached = 0L;
        long index1 = 0L;
        long index2 = 0L;
        int iindex1 = 0;
        long p = allAttributes.allSize();
        boolean fullRanking = this.getParameterAsBoolean(PARAMETER_FULL_RANKING);
        i = 1;
        while (true) {
            if ((long)i >= (useRankings ? (fullRanking ? p - 1L : Math.min(p - 1L, (long)(2 * k))) : (long)k)) break;
            it = allAttributes.regularAttributes();
            while (it.hasNext()) {
                att = ((AttributeRole)it.next()).getAttribute();
                iindex1 = att.getTableIndex();
                index1 = iindex1;
                for (e = 0; e < ensembleSize; ++e) {
                    if (selection[e].contains(att)) continue;
                    redundancy = 0.0;
                    counter = 0.0;
                    for (Attribute selected : selection[e]) {
                        double[] c_temp;
                        index2 = selected.getTableIndex();
                        Long cacheId = index1 > index2 ? Long.valueOf(index1 + index2 * p) : Long.valueOf(index1 * p + index2);
                        if (cache.containsKey(cacheId)) {
                            c_temp = (double[])cache.get(cacheId);
                            ++already_cached;
                        } else {
                            c_temp = MRMRFunctions.GetSimilarityEnsemble(exampleset, selected, att, ensembleSize);
                            cache.put(cacheId, c_temp);
                        }
                        redundancy = c_temp[e] > 0.0 ? (redundancy += c_temp[e]) : (redundancy -= c_temp[e]);
                        counter += 1.0;
                    }
                    if (counter != 0.0) {
                        redundancy /= counter;
                    }
                    if (method == 0) {
                        tmpPerf = Math.abs(((double[])relevance.get(iindex1))[e]);
                        if (tmpPerf != 0.0) {
                            tmpPerf = redundancy != 0.0 ? (tmpPerf /= redundancy) : Double.POSITIVE_INFINITY;
                        }
                    } else {
                        tmpPerf = Math.abs(((double[])relevance.get(iindex1))[e]) - redundancy;
                    }
                    if (!(tmpPerf > bestPerf[e])) continue;
                    bestPerf[e] = tmpPerf;
                    best[e] = att;
                }
            }
            for (e = 0; e < ensembleSize; ++e) {
                selection[e].add(best[e]);
                ranks[e].add(best[e]);
                bestPerf[e] = Double.NEGATIVE_INFINITY;
            }
            ++i;
        }
        if (useRankings) {
            result = this.joinByRank(ranks, exampleset);
            this.selectTopRankedK(result, k);
        } else {
            result = this.joinBySets(selection, exampleset);
            this.selectTopSelectedK(result, k);
        }
        this.cachesize = cache.size();
        this.comparisons += this.cachesize;
        if (this.logging) {
            this.log("Cached: " + already_cached + ", not cached (cache size): " + this.cachesize);
        }
        relevance.clear();
        relevance = null;
        cache.clear();
        cache = null;
        best = null;
        bestPerf = null;
        for (i = 0; i < ensembleSize; ++i) {
            selection[i].clear();
            selection[i] = null;
            ranks[i].clear();
            ranks[i] = null;
        }
        selection = null;
        ranks = null;
        return result;
    }

    protected void selectTopSelectedK(AttributeWeights weights, int k) {
        int j;
        String[] attributeNames = weights.getAttributeNames().toArray(new String[0]);
        weights.sortByWeight(attributeNames, -1, 0);
        for (j = 0; j < k && j < attributeNames.length; ++j) {
            weights.setWeight(attributeNames[j], 1.0);
        }
        for (j = k; j < attributeNames.length; ++j) {
            weights.setWeight(attributeNames[j], 0.0);
        }
    }

    protected void selectTopRankedK(AttributeWeights weights, int k) {
        int j;
        String[] attributeNames = weights.getAttributeNames().toArray(new String[0]);
        weights.sortByWeight(attributeNames, 1, 0);
        int zeros = 0;
        for (j = 0; j < k + zeros && j < attributeNames.length; ++j) {
            if (weights.getWeight(attributeNames[j]) == 0.0) {
                ++zeros;
                continue;
            }
            weights.setWeight(attributeNames[j], 1.0);
        }
        for (j = k + zeros; j < attributeNames.length; ++j) {
            weights.setWeight(attributeNames[j], 0.0);
        }
    }

    protected AttributeWeights joinBySets(Set<Attribute>[] selections, ExampleSet exampleSet) {
        AttributeWeights result = Util.CreateZeroWeights(exampleSet);
        for (int e = 0; e < selections.length; ++e) {
            for (Attribute a : selections[e]) {
                result.setWeight(a.getName(), result.getWeight(a.getName()) + 1.0);
            }
        }
        return result;
    }

    protected AttributeWeights joinByRank(List<Attribute>[] ranks, ExampleSet exampleSet) {
        AttributeWeights result = Util.CreateZeroWeights(exampleSet);
        double k3 = (double)ranks[0].size() * 3.0;
        for (int e = 0; e < ranks.length; ++e) {
            String att;
            Iterator i$ = result.getAttributeNames().iterator();
            while (i$.hasNext()) {
                String name;
                att = name = (String)i$.next();
                result.setWeight(att, result.getWeight(att) + k3);
            }
            for (int i = 0; i < ranks[e].size(); ++i) {
                att = ranks[e].get(i).getName();
                result.setWeight(att, result.getWeight(att) + (double)(i + 1) - k3);
            }
        }
        double E = ranks.length;
        for (String name : result.getAttributeNames()) {
            double w = result.getWeight(name);
            if (w == 0.0) {
                result.setWeight(name, Double.POSITIVE_INFINITY);
                continue;
            }
            result.setWeight(name, w / E);
        }
        return result;
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeCategory(PARAMETER_SETS_OR_RANKS, "Combine feature sets or feature rankings (must perform selection for ALL features).", SETS_OR_RANKS, 0));
        ParameterTypeBoolean type = new ParameterTypeBoolean(PARAMETER_FULL_RANKING, "Caculate the ranking of all features. Very Slow for high dimensional data! If set to false only the to top-k ranks will be calculated and a rank of 2k will be assumed for all other features", true);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_SETS_OR_RANKS, SETS_OR_RANKS, false, new int[]{1}));
        types.add(type);
        types.add(new ParameterTypeInt(PARAMETER_K, "Number of features to select", 0, Integer.MAX_VALUE, 100));
        types.add(new ParameterTypeCategory(PARAMETER_METHOD, "Difference or quotient of relevance and redundancy.", METHODS, 0));
        types.add(new ParameterTypeCategory(PARAMETER_ENSEMBLES, "Use ensembles method for similartiy measures or full selection process.", ENSEMBLE_METHODS, 0));
        type = new ParameterTypeInt(PARAMETER_ENSEMBLE_SIZE, "Size of the ensembles", 2, Integer.MAX_VALUE, 10);
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_LOG, "Log relevance and redundancy of each individual. Slow!", false));
        return types;
    }

    public boolean supportsCapability(OperatorCapability capability) {
        switch (capability) {
            case BINOMINAL_LABEL: 
            case POLYNOMINAL_LABEL: 
            case NUMERICAL_LABEL: 
            case BINOMINAL_ATTRIBUTES: 
            case POLYNOMINAL_ATTRIBUTES: 
            case NUMERICAL_ATTRIBUTES: {
                return true;
            }
        }
        return false;
    }
}

