/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.mrmr;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.mrmr.MRMRCache;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.GenerateNewMDRule;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import java.util.List;

public class MRMRCacheCreator
extends Operator {
    private final OutputPort cacheOut = (OutputPort)this.getOutputPorts().createPassThroughPort("cache");
    private final String PARAMETER_CACHESIZE = "cachesize";

    public MRMRCacheCreator(OperatorDescription description) {
        super(description);
        this.getTransformer().addRule((MDTransformationRule)new GenerateNewMDRule(this.cacheOut, MRMRCache.class));
    }

    public void doWork() throws OperatorException {
        int size = this.getParameterAsInt("cachesize");
        MRMRCache cache = new MRMRCache(size);
        this.cacheOut.deliver((IOObject)cache);
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeInt("cachesize", "Approximate upper bound for the cache size in MB.", 1, Integer.MAX_VALUE, 100));
        return types;
    }
}

